/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration.energy;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.items.electric.ElectricItem;
import ic2.api.items.electric.ICustomElectricItem;
import ic2.api.items.electric.IElectricItem;
import ic2.api.items.electric.IElectricItemManager;
import ic2.api.tiles.IEnergyStorage;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import sonar.fluxnetworks.api.energy.IBlockEnergyConnector;
import sonar.fluxnetworks.api.energy.IItemEnergyConnector;

public class IC2EnergyConnector
implements IBlockEnergyConnector,
IItemEnergyConnector {
    public static final IC2EnergyConnector INSTANCE = new IC2EnergyConnector();

    @Override
    public boolean hasCapability(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return target instanceof IEnergyTile || target instanceof IEnergyStorage;
    }

    @Override
    public boolean canSendTo(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return target instanceof IEnergySink || target instanceof IEnergyStorage;
    }

    @Override
    public boolean canReceiveFrom(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return false;
    }

    @Override
    public long sendTo(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        if (target instanceof IEnergyStorage) {
            IEnergyStorage sink = (IEnergyStorage)target;
            int before = sink.getStoredEU();
            if (!simulate) {
                return (long)sink.addEnergy((int)Math.min((long)(sink.getMaxEU() - before), amount >> 2)) << 2;
            }
            return Math.min((long)(sink.getMaxEU() - before), amount >> 2) << 2;
        }
        if (target instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)target;
            int voltage = EnergyNet.INSTANCE.getPowerFromTier(sink.getSinkTier());
            int a = (int)Math.min(amount >> 2, (long)voltage);
            if (simulate) {
                return (long)Math.min(a, sink.getRequestedEnergy()) << 2;
            }
            return (long)Math.floor(a - sink.acceptEnergy(side, a, voltage)) << 2;
        }
        return 0L;
    }

    @Override
    public long receiveFrom(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        return 0L;
    }

    @Override
    public boolean hasCapability(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() instanceof IElectricItem || stack.m_41720_() instanceof ICustomElectricItem);
    }

    @Override
    public boolean canSendTo(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() instanceof IElectricItem || stack.m_41720_() instanceof ICustomElectricItem);
    }

    @Override
    public boolean canReceiveFrom(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() instanceof IElectricItem || stack.m_41720_() instanceof ICustomElectricItem);
    }

    @Override
    public long sendTo(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IElectricItemManager manager = IC2EnergyConnector.getManager(stack);
        return (long)manager.charge(stack, (int)(amount >> 2), 4, false, simulate) << 2;
    }

    @Override
    public long receiveFrom(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IElectricItemManager manager = IC2EnergyConnector.getManager(stack);
        return (long)manager.discharge(stack, (int)(amount >> 2), 4, false, true, false) << 2;
    }

    public static IElectricItemManager getManager(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ICustomElectricItem) {
            ICustomElectricItem customElectricItem = (ICustomElectricItem)item;
            IElectricItemManager manager = customElectricItem.getManager(stack);
            if (manager == null) {
                manager = ElectricItem.getBackupManager((Item)stack.m_41720_());
            }
            return manager;
        }
        return ElectricItem.MANAGER;
    }
}

