/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.ColorUtils;

public class SensitiveGlassBlock
extends RsBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final ColorUtils.DyeColorProperty COLOR = ColorUtils.DyeColorProperty.create("color");

    public SensitiveGlassBlock(BlockBehaviour.Properties properties) {
        super(0x3000000000000000L, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
        this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COLOR, (Comparable)DyeColor.WHITE));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 0.95f;
    }

    @Override
    public RsBlock.RenderTypeHint getRenderTypeHint() {
        return RsBlock.RenderTypeHint.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (!(adjacentBlockState.m_60734_() instanceof SensitiveGlassBlock)) {
            return false;
        }
        return adjacentBlockState.m_61143_((Property)POWERED) == state.m_61143_((Property)POWERED);
    }

    @Override
    public boolean m_5568_() {
        return false;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED, COLOR});
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.m_5776_()) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !world.m_46753_(pos)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
        }
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Optional<DyeColor> dye = ColorUtils.getColorFromDyeItem(stack);
        if (dye.isEmpty()) {
            return InteractionResult.PASS;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)COLOR, (Comparable)dye.get()), 3);
        return world.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        if (world.m_5776_()) {
            return;
        }
        boolean was_powered = (Boolean)state.m_61143_((Property)POWERED);
        if (was_powered == (powered = world.m_46753_(pos))) {
            return;
        }
        if (powered) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        } else {
            world.m_186460_(pos, (Block)this, 4);
        }
    }
}

