/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;

public class SwitchLink {
    public final BlockPos target_position;
    public final String block_name;
    public final boolean valid;
    private long config;
    public int source_analog_power = 0;
    public int source_digital_power = 0;
    public BlockPos source_position = BlockPos.f_121853_;
    @Nullable
    public Level world;
    @Nullable
    public Player player;

    public SwitchLink() {
        this.target_position = BlockPos.f_121853_;
        this.block_name = "";
        this.config = 0L;
        this.valid = false;
    }

    public SwitchLink(BlockPos pos, String name, long cfg) {
        this.target_position = pos;
        this.block_name = name;
        this.config = cfg;
        this.valid = !this.block_name.isEmpty() && pos.m_121878_() != 0L;
    }

    public String toString() {
        return "SwitchLink{pos=" + this.target_position.toString() + ", block='" + this.block_name + "', config=" + Long.toString(this.config) + "}";
    }

    public LinkMode mode() {
        return LinkMode.fromInt((int)(this.config & 0xFL));
    }

    public SwitchLink mode(LinkMode rm) {
        this.config = this.config & 0xFFFFFFFFFFFFFFF0L | (long)rm.index();
        return this;
    }

    public static SwitchLink fromNbt(CompoundTag nbt) {
        return nbt == null ? new SwitchLink() : new SwitchLink(BlockPos.m_122022_((long)nbt.m_128454_("p")), nbt.m_128461_("b"), nbt.m_128454_("t"));
    }

    public static SwitchLink fromItemStack(ItemStack stack) {
        return stack == null || stack.m_41619_() || stack.m_41720_() != ModContent.SWITCH_LINK_PEARL ? new SwitchLink() : SwitchLink.fromNbt(stack.m_41783_());
    }

    public static SwitchLink fromTargetPosition(Level world, BlockPos pos) {
        if (pos == null) {
            return new SwitchLink();
        }
        BlockState state = world.m_8055_(pos);
        if (state == null || !(state.m_60734_() instanceof ISwitchLinkable)) {
            return new SwitchLink();
        }
        if (!((ISwitchLinkable)state.m_60734_()).switchLinkHasTargetSupport(world, pos)) {
            return new SwitchLink();
        }
        return new SwitchLink(pos, ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString(), 0L);
    }

    public static SwitchLink fromPlayerActiveItem(Level world, Player player) {
        if (player == null || world.m_5776_() || player.m_150109_() == null || player.m_150109_().m_36056_() == null) {
            return new SwitchLink();
        }
        if (player.m_150109_().m_36056_().m_41720_() != ModContent.SWITCH_LINK_PEARL) {
            return null;
        }
        return SwitchLink.fromNbt(player.m_150109_().m_36056_().m_41783_());
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("b", this.block_name);
        nbt.m_128356_("t", this.config);
        nbt.m_128356_("p", this.target_position.m_121878_());
        return nbt;
    }

    public ItemStack toSwitchLinkPearl() {
        ItemStack stack = new ItemStack((ItemLike)ModContent.SWITCH_LINK_PEARL);
        stack.m_41764_(1);
        stack.m_41751_(this.toNbt());
        return stack;
    }

    public int distance(@Nullable BlockPos pos) {
        return pos == null || !this.valid ? -1 : (int)Math.sqrt(this.target_position.m_123331_((Vec3i)pos));
    }

    public boolean isTooFar(BlockPos pos) {
        return ModConfig.max_switch_linking_distance > 0 && this.distance(pos) > ModConfig.max_switch_linking_distance;
    }

    @Nullable
    private ISwitchLinkable target(Level world, BlockPos source_pos) {
        if (ModConfig.without_switch_linking || !this.valid || this.isTooFar(source_pos) || !world.m_46805_(this.target_position)) {
            return null;
        }
        BlockState target_state = world.m_8055_(this.target_position);
        Block block = target_state.m_60734_();
        if (!(block instanceof ISwitchLinkable) || !ForgeRegistries.BLOCKS.getKey((Object)block).toString().equals(this.block_name)) {
            return null;
        }
        return (ISwitchLinkable)block;
    }

    public RequestResult trigger(Level world, BlockPos source_pos, Player player) {
        ISwitchLinkable target;
        block8: {
            block7: {
                if (ModConfig.without_switch_linking) {
                    return RequestResult.NOT_MATCHED;
                }
                if (!this.valid || world.m_5776_()) {
                    return RequestResult.INVALID_LINKDATA;
                }
                if (this.isTooFar(source_pos) || !world.m_46805_(this.target_position)) {
                    return RequestResult.TOO_FAR;
                }
                BlockState target_state = world.m_8055_(this.target_position);
                if (target_state == null) {
                    return RequestResult.TOO_FAR;
                }
                Block block = target_state.m_60734_();
                if (!(block instanceof ISwitchLinkable)) break block7;
                target = (ISwitchLinkable)block;
                if (ForgeRegistries.BLOCKS.getKey((Object)block).toString().equals(this.block_name)) break block8;
            }
            return RequestResult.TARGET_GONE;
        }
        int p = target.switchLinkOutputPower(world, this.target_position).orElse(0);
        this.world = world;
        this.source_position = source_pos;
        this.player = player;
        this.source_digital_power = this.source_analog_power = p <= 0 ? 15 : 0;
        return target.switchLinkTrigger(this);
    }

    public RequestResult trigger(Level world, BlockPos source_pos, int analog_power, int digital_power, boolean state_changed) {
        ISwitchLinkable target = this.target(world, source_pos);
        if (target == null) {
            return RequestResult.REJECTED;
        }
        this.player = null;
        this.world = world;
        this.source_position = source_pos;
        this.source_analog_power = analog_power;
        this.source_digital_power = digital_power;
        int target_power = target.switchLinkOutputPower(world, this.target_position).orElse(-1);
        if (target_power < 0) {
            return RequestResult.REJECTED;
        }
        boolean analog = target.switchLinkHasAnalogSupport(world, this.target_position);
        switch (this.mode()) {
            case AS_STATE: {
                if (!(analog ? target_power == analog_power : !state_changed || target_power == 0 == (digital_power == 0))) break;
                return RequestResult.NOT_MATCHED;
            }
            case INV_STATE: {
                if (analog) {
                    this.source_analog_power = analog_power = 15 - analog_power;
                    if (target_power != analog_power) break;
                    return RequestResult.NOT_MATCHED;
                }
                if (state_changed && target_power == 0 == (digital_power == 0)) break;
                return RequestResult.NOT_MATCHED;
            }
            case ACTIVATE: {
                if (state_changed && digital_power != 0) break;
                return RequestResult.NOT_MATCHED;
            }
            case DEACTIVATE: {
                if (state_changed && digital_power == 0) break;
                return RequestResult.NOT_MATCHED;
            }
            case TOGGLE: {
                if (state_changed) break;
                return RequestResult.NOT_MATCHED;
            }
        }
        return target.switchLinkTrigger(this);
    }

    public void unlinkTarget(Level world, BlockPos source_pos) {
        ISwitchLinkable target = this.target(world, this.target_position);
        if (target == null) {
            return;
        }
        this.world = world;
        this.source_position = source_pos;
        this.player = null;
        target.switchLinkUnlink(this);
    }

    public void initializeTarget(Level world, BlockPos source_pos, int analog_power, int digital_power) {
        ISwitchLinkable target = this.target(world, this.target_position);
        if (target == null) {
            return;
        }
        this.world = world;
        this.source_position = source_pos;
        this.source_analog_power = analog_power;
        this.source_digital_power = digital_power;
        this.player = null;
        target.switchLinkInit(this);
    }

    public static Optional<Integer> getOutputPower(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return !(state.m_60734_() instanceof ISwitchLinkable) ? Optional.empty() : ((ISwitchLinkable)state.m_60734_()).switchLinkOutputPower(world, pos);
    }

    public static Optional<Integer> getInputPower(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return !(state.m_60734_() instanceof ISwitchLinkable) ? Optional.empty() : ((ISwitchLinkable)state.m_60734_()).switchLinkInputPower(world, pos);
    }

    public static Optional<Integer> getComparatorInput(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return !(state.m_60734_() instanceof ISwitchLinkable) ? Optional.empty() : ((ISwitchLinkable)state.m_60734_()).switchLinkComparatorInput(world, pos);
    }

    public static enum LinkMode {
        AS_STATE(0),
        ACTIVATE(1),
        DEACTIVATE(2),
        TOGGLE(3),
        INV_STATE(4);

        private static final LinkMode[] VALUES;
        private static final LinkMode[] BY_INDEX;
        private final int index_;

        private LinkMode(int i) {
            this.index_ = i;
        }

        public int index() {
            return this.index_;
        }

        static LinkMode fromInt(int val) {
            return BY_INDEX[Mth.m_14045_((int)val, (int)0, (int)(VALUES.length - 1))];
        }

        public long toInt() {
            return this.index();
        }

        static {
            VALUES = LinkMode.values();
            BY_INDEX = (LinkMode[])Arrays.stream(LinkMode.values()).sorted(Comparator.comparingInt(v -> v.index_)).toArray(LinkMode[]::new);
        }
    }

    public static interface ISwitchLinkable {
        public boolean switchLinkHasTargetSupport(Level var1, BlockPos var2);

        public boolean switchLinkHasSourceSupport(Level var1, BlockPos var2);

        public boolean switchLinkHasAnalogSupport(Level var1, BlockPos var2);

        public void switchLinkUnlink(SwitchLink var1);

        public void switchLinkInit(SwitchLink var1);

        default public ImmutableList<LinkMode> switchLinkGetSupportedTargetModes() {
            return ImmutableList.of((Object)((Object)LinkMode.AS_STATE), (Object)((Object)LinkMode.ACTIVATE), (Object)((Object)LinkMode.DEACTIVATE), (Object)((Object)LinkMode.TOGGLE), (Object)((Object)LinkMode.INV_STATE));
        }

        public RequestResult switchLinkTrigger(SwitchLink var1);

        public Optional<Integer> switchLinkOutputPower(Level var1, BlockPos var2);

        public Optional<Integer> switchLinkInputPower(Level var1, BlockPos var2);

        public Optional<Integer> switchLinkComparatorInput(Level var1, BlockPos var2);
    }

    public static enum RequestResult {
        OK,
        NOT_MATCHED,
        INVALID_LINKDATA,
        TOO_FAR,
        TARGET_GONE,
        REJECTED;

    }
}

