/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.libmc.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import wile.rsgauges.detail.ModResources;

public class Registries {
    private static String modid = null;
    private static String creative_tab_icon = "";
    private static CreativeModeTab creative_tab = null;
    private static final DeferredRegister<Block> block_deferred_register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"rsgauges");
    private static final DeferredRegister<Item> item_deferred_register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"rsgauges");
    private static final DeferredRegister<BlockEntityType<?>> block_entity_deferred_register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"rsgauges");
    private static final DeferredRegister<EntityType<?>> entity_deferred_register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"rsgauges");
    private static final DeferredRegister<MenuType<?>> menu_deferred_register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"rsgauges");
    public static final DeferredRegister<SoundEvent> sound_deferred_register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"rsgauges");
    private static final Map<String, RegistryObject<Block>> registered_blocks = new HashMap<String, RegistryObject<Block>>();
    private static final Map<String, RegistryObject<Item>> registered_items = new HashMap<String, RegistryObject<Item>>();
    private static final Map<String, RegistryObject<BlockEntityType<?>>> registered_block_entity_types = new HashMap();
    private static final Map<String, RegistryObject<EntityType<?>>> registered_entity_types = new HashMap();
    private static final Map<String, RegistryObject<MenuType<?>>> registered_menu_types = new HashMap();
    private static final Map<String, TagKey<Block>> registered_block_tag_keys = new HashMap<String, TagKey<Block>>();
    private static final Map<String, TagKey<Item>> registered_item_tag_keys = new HashMap<String, TagKey<Item>>();
    private static final ArrayList<Pair<Class<?>, RegistryObject<Block>>> registered_block_classes = new ArrayList();

    public static void init(String mod_id, String creative_tab_icon_item_name) {
        modid = mod_id;
        creative_tab_icon = creative_tab_icon_item_name;
    }

    public static CreativeModeTab getCreativeModeTab() {
        if (creative_tab == null) {
            creative_tab = new CreativeModeTab("tab" + modid){

                public ItemStack m_6976_() {
                    return new ItemStack((ItemLike)registered_items.get(creative_tab_icon).get());
                }
            };
        }
        return creative_tab;
    }

    public static Block getBlock(String block_name) {
        return (Block)registered_blocks.get(block_name).get();
    }

    public static Item getItem(String name) {
        return (Item)registered_items.get(name).get();
    }

    public static EntityType<?> getEntityType(String name) {
        return (EntityType)registered_entity_types.get(name).get();
    }

    public static BlockEntityType<?> getBlockEntityType(String block_name) {
        return (BlockEntityType)registered_block_entity_types.get(block_name).get();
    }

    public static MenuType<?> getMenuType(String name) {
        return (MenuType)registered_menu_types.get(name).get();
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(String block_name) {
        return Registries.getBlockEntityType("tet_" + block_name);
    }

    public static MenuType<?> getMenuTypeOfBlock(String name) {
        return Registries.getMenuType("ct_" + name);
    }

    public static TagKey<Block> getBlockTagKey(String name) {
        return registered_block_tag_keys.get(name);
    }

    public static TagKey<Item> getItemTagKey(String name) {
        return registered_item_tag_keys.get(name);
    }

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return registered_blocks.values().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return registered_items.values().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    @Nonnull
    public static List<BlockEntityType<?>> getRegisteredBlockEntityTypes() {
        return registered_block_entity_types.values().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    @Nonnull
    public static List<EntityType<?>> getRegisteredEntityTypes() {
        return registered_entity_types.values().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    public static <T extends Item> void addItem(String registry_name, Supplier<T> supplier) {
        RegistryObject item = item_deferred_register.register(registry_name, supplier);
        registered_items.put(registry_name, (RegistryObject<Item>)item);
    }

    public static <T extends Block> void addBlock(String registry_name, Supplier<T> block_supplier, Class<?> clazz) {
        RegistryObject block = block_deferred_register.register(registry_name, block_supplier);
        RegistryObject blockItem = item_deferred_register.register(registry_name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(Registries.getCreativeModeTab())));
        registered_blocks.put(registry_name, (RegistryObject<Block>)block);
        registered_items.put(registry_name, (RegistryObject<Item>)blockItem);
        registered_block_classes.add(Pair.of(clazz, (Object)block));
    }

    public static <T extends BlockEntity> void addBlockEntityType(String registry_name, BlockEntityType.BlockEntitySupplier<T> ctor, String ... block_names) {
        ArrayList<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
        for (String str : block_names) {
            blocks.add(registered_blocks.get(str));
        }
        RegistryObject blockEntityType = block_entity_deferred_register.register(registry_name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)ctor, (Block[])blocks.stream().map(RegistryObject::get).toList().toArray(new Block[0])).m_58966_(null));
        registered_block_entity_types.put(registry_name, blockEntityType);
    }

    public static <T extends BlockEntity> void addBlockEntityType(String registry_name, BlockEntityType.BlockEntitySupplier<T> ctor, Class<? extends Block> block_clazz) {
        ArrayList<RegistryObject> blocks = new ArrayList<RegistryObject>();
        for (Pair<Class<?>, RegistryObject<Block>> block : registered_block_classes) {
            if (!block_clazz.isAssignableFrom((Class)block.getLeft())) continue;
            blocks.add((RegistryObject)block.getRight());
        }
        RegistryObject blockEntityType = block_entity_deferred_register.register(registry_name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)ctor, (Block[])blocks.stream().map(RegistryObject::get).toList().toArray(new Block[0])).m_58966_(null));
        registered_block_entity_types.put(registry_name, blockEntityType);
    }

    public static void addEntityType(String registry_name, Supplier<EntityType<?>> supplier) {
        RegistryObject entityType = entity_deferred_register.register(registry_name, supplier);
        registered_entity_types.put(registry_name, entityType);
    }

    public static void addMenuType(String registry_name, MenuType.MenuSupplier<?> supplier) {
        RegistryObject menuType = menu_deferred_register.register(registry_name, () -> new MenuType(supplier));
        registered_menu_types.put(registry_name, menuType);
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor, Class<?> clazz) {
        Registries.addBlock(registry_name, block_supplier, clazz);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor, MenuType.MenuSupplier<?> menu_type_supplier, Class<?> clazz) {
        Registries.addBlock(registry_name, block_supplier, clazz);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
        Registries.addMenuType("ct_" + registry_name, menu_type_supplier);
    }

    public static void addOptionalBlockTag(String tag_name, ResourceLocation ... default_blocks) {
        HashSet<Supplier<Block>> default_suppliers = new HashSet<Supplier<Block>>();
        for (ResourceLocation rl : default_blocks) {
            default_suppliers.add(() -> (Block)ForgeRegistries.BLOCKS.getValue(rl));
        }
        TagKey key = ForgeRegistries.BLOCKS.tags().createOptionalTagKey(new ResourceLocation(modid, tag_name), default_suppliers);
        registered_block_tag_keys.put(tag_name, (TagKey<Block>)key);
    }

    public static void addOptionalBlockTag(String tag_name, String ... default_blocks) {
        Registries.addOptionalBlockTag(tag_name, Arrays.stream(default_blocks).map(ResourceLocation::new).toList().toArray(new ResourceLocation[0]));
    }

    public static void addOptionaItemTag(String tag_name, ResourceLocation ... default_items) {
        HashSet<Supplier<Item>> default_suppliers = new HashSet<Supplier<Item>>();
        for (ResourceLocation rl : default_items) {
            default_suppliers.add(() -> (Item)ForgeRegistries.ITEMS.getValue(rl));
        }
        TagKey key = ForgeRegistries.ITEMS.tags().createOptionalTagKey(new ResourceLocation(modid, tag_name), default_suppliers);
        registered_item_tag_keys.put(tag_name, (TagKey<Item>)key);
    }

    public static void registerAll() {
        ModResources.ALARM_SIREN_SOUND = ModResources.createSoundEvent("alarm_siren_sound");
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        block_deferred_register.register(eventBus);
        item_deferred_register.register(eventBus);
        block_entity_deferred_register.register(eventBus);
        entity_deferred_register.register(eventBus);
        menu_deferred_register.register(eventBus);
        sound_deferred_register.register(eventBus);
    }
}

