/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.api;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.particle.CustomBreakingParticle;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.api.MicroMaterialClient;
import codechicken.microblock.client.MicroblockRender;
import codechicken.microblock.part.MicroblockPart;
import codechicken.microblock.util.MaskedCuboid;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BlockMicroMaterial
extends MicroMaterial {
    public final BlockState state;

    public BlockMicroMaterial(Block block) {
        this(block.m_49966_());
    }

    public BlockMicroMaterial(BlockState state) {
        this.state = state;
    }

    @Override
    public boolean isTransparent() {
        return !this.state.m_60815_();
    }

    @Override
    public int getLightEmission() {
        return this.state.m_60791_();
    }

    @Override
    public float getStrength(Player player) {
        return this.state.m_60625_(player, (BlockGetter)player.f_19853_, new BlockPos(0, -1, 0));
    }

    @Override
    public Component getLocalizedName() {
        return this.getItem().m_41786_();
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)this.state.m_60734_(), 1);
    }

    @Override
    @Nullable
    public Tier getCutterTier() {
        for (Tier tier : TierSortingRegistry.getSortedTiers()) {
            if (!TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)this.state)) continue;
            return tier;
        }
        return null;
    }

    @Override
    public SoundType getSound() {
        return this.state.m_60734_().m_49962_(this.state);
    }

    @Override
    public float getExplosionResistance(BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.state.getExplosionResistance(level, pos, explosion);
    }

    @Override
    public void initializeClient(Consumer<MicroMaterialClient> cons) {
        cons.accept(new MicroMaterialClient(){

            @Override
            public RenderType getItemRenderLayer() {
                return ItemBlockRenderTypes.m_109284_((BlockState)BlockMicroMaterial.this.state, (boolean)true);
            }

            @Override
            public void renderCuboids(CCRenderState ccrs, @Nullable RenderType layer, Iterable<MaskedCuboid> cuboids) {
                MicroblockRender.renderCuboids(ccrs, BlockMicroMaterial.this.state, layer, cuboids);
            }

            @Override
            public void addHitEffects(MicroblockPart part, PartRayTraceResult hit, ParticleEngine engine) {
                CustomParticleHandler.addBlockHitEffects((Level)part.level(), (Cuboid6)part.getBounds().copy().add(part.pos()), (Direction)hit.m_82434_(), (TextureAtlasSprite)this.getSprite(part.level(), part.pos()), (ParticleEngine)engine);
            }

            @Override
            public void addDestroyEffects(MicroblockPart part, PartRayTraceResult hit, ParticleEngine engine) {
                CustomParticleHandler.addBlockDestroyEffects((Level)part.level(), (Cuboid6)part.getBounds().copy().add(part.pos()), List.of(this.getSprite(part.level(), part.pos())), (ParticleEngine)engine);
            }

            @Override
            public void addLandingEffects(MicroblockPart part, PartRayTraceResult hit, Vector3 entity, int numberOfParticles) {
                Level level = part.level();
                ParticleEngine manager = Minecraft.m_91087_().f_91061_;
                TextureAtlasSprite sprite = this.getSprite(level, part.pos());
                if (numberOfParticles != 0) {
                    for (int i = 0; i < numberOfParticles; ++i) {
                        double mX = level.f_46441_.m_188583_() * (double)0.15f;
                        double mY = level.f_46441_.m_188583_() * (double)0.15f;
                        double mZ = level.f_46441_.m_188583_() * (double)0.15f;
                        manager.m_107344_((Particle)CustomBreakingParticle.newLandingParticle((ClientLevel)((ClientLevel)level), (double)entity.x, (double)entity.y, (double)entity.z, (double)mX, (double)mY, (double)mZ, (TextureAtlasSprite)sprite));
                    }
                }
            }

            @Override
            public void addRunningEffects(MicroblockPart part, PartRayTraceResult hit, Entity entity) {
                Level level = part.level();
                ParticleEngine manager = Minecraft.m_91087_().f_91061_;
                TextureAtlasSprite sprite = this.getSprite(level, part.pos());
                double x = entity.m_20185_() + ((double)level.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_();
                double y = entity.m_20191_().f_82289_ + 0.1;
                double z = entity.m_20189_() + ((double)level.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_();
                manager.m_107344_((Particle)new CustomBreakingParticle((ClientLevel)level, x, y, z, -entity.m_20184_().f_82479_ * 4.0, 1.5, -entity.m_20184_().f_82481_ * 4.0, sprite));
            }

            private TextureAtlasSprite getSprite(Level level, BlockPos pos) {
                return Minecraft.m_91087_().m_91289_().m_110907_().getTexture(BlockMicroMaterial.this.state, level, pos);
            }
        });
    }

    public static ResourceLocation makeMaterialKey(BlockState state) {
        Block block = state.m_60734_();
        StringBuilder path = new StringBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_());
        if (!state.m_61147_().isEmpty()) {
            path.append("//");
            for (Map.Entry entry : state.m_61148_().entrySet()) {
                Property property = (Property)entry.getKey();
                if (path.charAt(path.length() - 2) != '/') {
                    path.append('/');
                }
                path.append(property.m_61708_()).append('.').append(property.m_6940_((Comparable)SneakyUtils.unsafeCast(entry.getValue())));
            }
        }
        return new ResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)block).m_135827_(), path.toString());
    }
}

