/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.init;

import codechicken.lib.gui.SimpleCreativeTab;
import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.MicroMaterialConfig;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.item.SawItem;
import codechicken.microblock.part.corner.CornerMicroFactory;
import codechicken.microblock.part.edge.EdgeMicroFactory;
import codechicken.microblock.part.edge.PostMicroblockFactory;
import codechicken.microblock.part.face.FaceMicroFactory;
import codechicken.microblock.part.hollow.HollowMicroFactory;
import codechicken.microblock.recipe.MicroRecipe;
import codechicken.microblock.util.MicroMaterialRegistry;
import codechicken.multipart.api.MultipartType;
import java.nio.file.Paths;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CBMicroblockModContent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registry.f_122904_, (String)"cb_microblock");
    private static final DeferredRegister<MultipartType<?>> MULTIPART_TYPES = DeferredRegister.create((ResourceLocation)new ResourceLocation("cb_multipart", "multipart_types"), (String)"cb_microblock");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registry.f_122915_, (String)"cb_microblock");
    public static final SimpleCreativeTab MICRO_TAB = new SimpleCreativeTab("cb_microblock", () -> ItemMicroBlock.create(1, 2, MicroMaterialRegistry.getMaterial(BlockMicroMaterial.makeMaterialKey(Blocks.f_50440_.m_49966_())))){

        public boolean hasSearchBar() {
            return true;
        }
    };
    public static final RegistryObject<ItemMicroBlock> MICRO_BLOCK_ITEM = ITEMS.register("microblock", () -> new ItemMicroBlock(new Item.Properties().m_41491_((CreativeModeTab)MICRO_TAB)));
    public static final RegistryObject<Item> STONE_ROD_ITEM = ITEMS.register("stone_rod", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistryObject<SawItem> STONE_SAW = ITEMS.register("stone_saw", () -> new SawItem((Tier)Tiers.STONE, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).setNoRepair()));
    public static final RegistryObject<SawItem> IRON_SAW = ITEMS.register("iron_saw", () -> new SawItem((Tier)Tiers.IRON, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).setNoRepair()));
    public static final RegistryObject<SawItem> DIAMOND_SAW = ITEMS.register("diamond_saw", () -> new SawItem((Tier)Tiers.DIAMOND, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).setNoRepair()));
    public static final RegistryObject<FaceMicroFactory> FACE_MICROBLOCK_PART = MULTIPART_TYPES.register("face", FaceMicroFactory::new);
    public static final RegistryObject<HollowMicroFactory> HOLLOW_MICROBLOCK_PART = MULTIPART_TYPES.register("hollow", HollowMicroFactory::new);
    public static final RegistryObject<CornerMicroFactory> CORNER_MICROBLOCK_PART = MULTIPART_TYPES.register("corner", CornerMicroFactory::new);
    public static final RegistryObject<EdgeMicroFactory> EDGE_MICROBLOCK_PART = MULTIPART_TYPES.register("edge", EdgeMicroFactory::new);
    public static final RegistryObject<PostMicroblockFactory> POST_MICROBLOCK_PART = MULTIPART_TYPES.register("post", PostMicroblockFactory::new);
    public static final RegistryObject<SimpleRecipeSerializer<?>> MICRO_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("microblock", () -> new SimpleRecipeSerializer(MicroRecipe::new));
    @Nullable
    public static Tier MAX_SAW_TIER;

    public static void init() {
        LOCK.lock();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        MULTIPART_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        bus.addListener(CBMicroblockModContent::onRegisterMicroMaterials);
        bus.addListener(CBMicroblockModContent::onCommonSetup);
        bus.addListener(CBMicroblockModContent::onProcessIMC);
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        Tier tier = null;
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            Tier found = SawItem.getSawTier(item);
            if (found == null || tier != null && !SawItem.isTierGTEQ(found, tier)) continue;
            tier = found;
        }
        MAX_SAW_TIER = tier;
    }

    private static void onProcessIMC(InterModProcessEvent event) {
        CBMicroblockModContent.processIMC(event);
        MicroMaterialConfig.parse(Paths.get("config", "custom-micromaterials.cfg"));
    }

    private static void onRegisterMicroMaterials(RegisterEvent event) {
        event.register(MicroMaterialRegistry.MICRO_MATERIALS.getRegistryKey(), r -> {
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50069_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50122_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50175_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50228_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50281_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50334_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50387_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50440_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50493_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50546_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50599_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50652_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50705_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50741_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50742_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50743_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50744_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50745_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220865_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49992_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49993_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49994_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49995_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152467_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49996_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152468_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49997_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152469_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49998_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_49999_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50000_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50001_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50002_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50003_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50004_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220832_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220833_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220834_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50005_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50006_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50007_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50008_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50009_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50010_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220835_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50011_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50012_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50013_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50014_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50015_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50043_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220836_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50044_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50045_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50046_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50047_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50048_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50049_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220837_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50050_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50051_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50052_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50053_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50054_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50055_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220838_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152470_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152471_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50056_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50057_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50058_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50059_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152472_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50060_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50062_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50063_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50064_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50041_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50042_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50096_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50097_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50098_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50099_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50100_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50101_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50102_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50103_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50104_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50105_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50106_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50107_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50108_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50109_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50074_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50075_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50076_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50077_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50078_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50079_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50080_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50089_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152474_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50090_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50091_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50173_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152473_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50126_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50127_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50129_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50133_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50134_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50135_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50136_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50137_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50138_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50141_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50143_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50144_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50147_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50148_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50202_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50203_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50204_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50205_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50206_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50207_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50208_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50209_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50210_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50211_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50212_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50213_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50214_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50215_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50222_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50223_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50224_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50225_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220843_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220844_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50180_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50181_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50182_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50186_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50195_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50197_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50259_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial((BlockState)Blocks.f_50261_.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true))));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50264_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152479_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50268_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50330_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50331_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50333_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50282_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50283_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50287_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50288_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50289_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50290_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50291_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50292_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50293_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50294_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50295_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50296_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50297_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50298_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50299_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50300_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50301_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50302_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50374_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50377_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50378_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50379_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50386_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50335_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50352_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50353_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50354_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50394_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50395_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50396_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50470_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50471_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50472_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50473_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50492_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50441_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50443_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152481_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50450_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50451_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50452_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50453_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50526_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50527_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50528_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50529_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50530_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50531_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50532_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50533_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50534_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50535_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50536_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50537_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50538_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50539_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50540_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50541_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50542_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50543_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50544_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50545_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50494_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50495_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50496_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50497_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50498_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50499_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50500_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50501_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50502_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50503_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50504_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50505_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50506_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50507_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50508_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50509_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50510_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50511_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50512_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50513_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50514_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50515_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50516_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50517_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50518_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50519_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50573_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50574_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50577_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50579_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50580_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50581_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50582_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50583_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50584_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50585_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50586_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50587_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50588_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50568_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50690_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50692_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50699_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50655_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50656_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50719_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50720_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50721_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50722_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50723_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50729_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50730_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50734_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50735_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50736_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50737_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50706_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50712_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50713_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_50714_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152490_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152496_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152497_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152498_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152501_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152502_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152503_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152504_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152505_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152506_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152507_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152508_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152509_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152510_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152571_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152572_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152573_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152574_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152575_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152576_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152577_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152578_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152537_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152549_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220864_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152550_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152551_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152555_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152559_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152589_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152593_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152594_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152595_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152597_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152598_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152599_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_152600_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220859_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220860_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220861_));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.f_220863_));
        });
    }

    private static void registerMaterial(RegisterEvent.RegisterHelper<MicroMaterial> r, BlockMicroMaterial material) {
        r.register(BlockMicroMaterial.makeMaterialKey(material.state), (Object)material);
    }

    private static void processIMC(InterModProcessEvent event) {
        ForgeRegistry registry = (ForgeRegistry)MicroMaterialRegistry.MICRO_MATERIALS;
        registry.unfreeze();
        event.getIMCStream().forEach(e -> {
            BlockMicroMaterial material;
            if (!e.method().equals("micro_material")) {
                return;
            }
            String sender = e.senderModId();
            Object sent = e.messageSupplier().get();
            if (sent instanceof Block) {
                Block b = (Block)sent;
                material = new BlockMicroMaterial(b);
            } else if (sent instanceof BlockState) {
                BlockState s = (BlockState)sent;
                material = new BlockMicroMaterial(s);
            } else {
                LOGGER.error("Mod {} tried to register a MicroMaterial with an invalid message. Object: '{}', Class: '{}'. IMC only supports Block or BlockState messages.", (Object)sender, sent, sent != null ? sent.getClass().getName() : null);
                return;
            }
            ResourceLocation key = BlockMicroMaterial.makeMaterialKey(material.state);
            if (registry.containsKey(key)) {
                LOGGER.warn("Mod '{}' tried to register a duplicate MicroMaterial. '{}'. Ignoring.", (Object)sender, (Object)key);
                return;
            }
            registry.register(key, (Object)material);
        });
        registry.freeze();
    }
}

