/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.init;

import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.init.CBMicroblockTags;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataGenerators::registerDataGens);
    }

    private static void registerDataGens(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper files = event.getExistingFileHelper();
        gen.m_236039_(event.includeClient(), (DataProvider)new ItemModels(gen, files));
        gen.m_236039_(event.includeServer(), (DataProvider)new ItemTagGen(gen, new BlockTagsProvider(gen), files));
        gen.m_236039_(event.includeServer(), (DataProvider)new Recipes(gen));
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "cb_microblock", existingFileHelper);
        }

        protected void registerModels() {
            this.generated((ItemLike)CBMicroblockModContent.MICRO_BLOCK_ITEM.get()).noTexture();
            this.generated((ItemLike)CBMicroblockModContent.STONE_ROD_ITEM.get());
            this.generated((ItemLike)CBMicroblockModContent.STONE_SAW.get());
            this.generated((ItemLike)CBMicroblockModContent.IRON_SAW.get());
            this.generated((ItemLike)CBMicroblockModContent.DIAMOND_SAW.get());
        }

        public String m_6055_() {
            return "CBMicroblock Item Models";
        }
    }

    private static class ItemTagGen
    extends ItemTagsProvider {
        public ItemTagGen(DataGenerator dataGen, BlockTagsProvider blockTags, @Nullable ExistingFileHelper files) {
            super(dataGen, blockTags, "cb_microblock", files);
        }

        protected void m_6577_() {
            this.m_206424_(CBMicroblockTags.Items.TOOL_SAW).m_126582_((Object)((Item)CBMicroblockModContent.STONE_SAW.get())).m_126582_((Object)((Item)CBMicroblockModContent.IRON_SAW.get())).m_126582_((Object)((Item)CBMicroblockModContent.DIAMOND_SAW.get()));
            this.m_206424_(CBMicroblockTags.Items.STONE_ROD).m_126582_((Object)((Item)CBMicroblockModContent.STONE_ROD_ITEM.get()));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void registerRecipes() {
            this.special((SimpleRecipeSerializer)CBMicroblockModContent.MICRO_RECIPE_SERIALIZER.get(), new ResourceLocation("cb_microblock", "microblock"));
            this.shapedRecipe((ItemLike)CBMicroblockModContent.STONE_ROD_ITEM.get()).key('S', Tags.Items.COBBLESTONE).patternLine("S").patternLine("S");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.STONE_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', (ItemLike)Items.f_42484_).patternLine("SRR").patternLine("SMR");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.IRON_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', Tags.Items.INGOTS_IRON).patternLine("SRR").patternLine("SMR");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.DIAMOND_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', Tags.Items.GEMS_DIAMOND).patternLine("SRR").patternLine("SMR");
        }

        public String m_6055_() {
            return "CBMicroblock Recipes";
        }
    }
}

