/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.part.ExecutablePlacement;
import codechicken.microblock.part.MicroblockPart;
import codechicken.microblock.part.MicroblockPartFactory;
import codechicken.microblock.part.PlacementProperties;
import codechicken.microblock.part.StandardMicroblockPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.ControlKeyModifier;
import codechicken.multipart.util.MultipartHelper;
import codechicken.multipart.util.MultipartPlaceContext;
import codechicken.multipart.util.PartRayTraceResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MicroblockPlacement {
    public final Player player;
    public final InteractionHand hand;
    public final BlockHitResult hit;
    public final int size;
    public final MicroMaterial material;
    public final boolean checkMaterial;
    public final PlacementProperties pp;
    public final Level level;
    public final MicroblockPartFactory microFactory;
    public final BlockPos pos;
    public final Vector3 vHit;
    public final Pair<TileMultipart, Boolean> gTile;
    public final TileMultipart hTile;
    public final int side;
    public final int slot;
    public final int oSlot;
    public final double hitDepth;
    public final boolean useOppMod;
    public final boolean oppMod;
    public final boolean internal;
    public final boolean doExpand;

    public MicroblockPlacement(Player player, InteractionHand hand, BlockHitResult hit, int size, MicroMaterial material, boolean checkMaterial, PlacementProperties pp) {
        this.player = player;
        this.hand = hand;
        this.hit = hit;
        this.size = size;
        this.material = material;
        this.checkMaterial = checkMaterial;
        this.pp = pp;
        this.level = player.f_19853_;
        this.microFactory = pp.microFactory();
        this.pos = hit.m_82425_();
        this.vHit = new Vector3(hit.m_82450_()).subtract(this.pos);
        this.gTile = MultipartHelper.getOrConvertTile2(this.level, this.pos);
        this.hTile = (TileMultipart)((Object)this.gTile.getLeft());
        this.side = hit.m_82434_().ordinal();
        this.slot = pp.placementGrid().getHitSlot(this.vHit, this.side);
        this.oSlot = pp.opposite(this.slot, this.side);
        this.hitDepth = MicroblockPlacement.getHitDepth(this.vHit, this.side);
        this.useOppMod = pp.sneakOpposite(this.slot, this.side);
        this.oppMod = ControlKeyModifier.isControlDown(player);
        this.internal = this.hitDepth < 1.0 && this.hTile != null;
        this.doExpand = this.internal && (Boolean)this.gTile.getRight() == false && !player.m_6047_() && (!this.oppMod || !this.useOppMod) && pp.expand(this.slot, this.side);
    }

    @Nullable
    public ExecutablePlacement calculate() {
        MultiPart hPart;
        ExecutablePlacement customPlacement = this.pp.customPlacement(this);
        if (customPlacement != null) {
            return customPlacement;
        }
        if (this.slot < 0) {
            return null;
        }
        if (this.doExpand && (hPart = ((PartRayTraceResult)this.hit).part).getType() == this.microFactory) {
            StandardMicroblockPart mPart = (StandardMicroblockPart)hPart;
            if (mPart.material == this.material && mPart.getSize() + this.size < 8) {
                return this.expand(mPart);
            }
        }
        if (this.internal) {
            ExecutablePlacement ret;
            if ((this.hitDepth < 0.5 || !this.useOppMod) && (ret = this.internalPlacement(this.hTile, this.slot)) != null) {
                if (this.useOppMod && this.oppMod) {
                    return this.internalPlacement(this.hTile, this.oSlot);
                }
                return ret;
            }
            if (this.useOppMod && !this.oppMod) {
                return this.internalPlacement(this.hTile, this.oSlot);
            }
            return this.externalPlacement(this.slot);
        }
        if (this.useOppMod && this.oppMod) {
            return this.externalPlacement(this.oSlot);
        }
        return this.externalPlacement(this.slot);
    }

    @Nullable
    public ExecutablePlacement expand(StandardMicroblockPart part) {
        return this.expand(part, this.create(part.getSize() + this.size, part.getSlot(), part.material));
    }

    @Nullable
    public ExecutablePlacement expand(MicroblockPart mPart, MicroblockPart nPart) {
        BlockPos pos = mPart.pos();
        if (TileMultipart.isUnobstructed(this.level, pos, nPart) && mPart.tile().canReplacePart(mPart, nPart)) {
            return new ExecutablePlacement.ExpandingPlacement(pos, nPart, mPart);
        }
        return null;
    }

    @Nullable
    public ExecutablePlacement internalPlacement(TileMultipart tile, int slot) {
        return this.internalPlacement(tile, this.create(this.size, slot, this.material));
    }

    @Nullable
    public ExecutablePlacement internalPlacement(TileMultipart tile, MicroblockPart part) {
        BlockPos pos = tile.m_58899_();
        if (TileMultipart.isUnobstructed(this.level, pos, part) && tile.canAddPart(part)) {
            return new ExecutablePlacement.AdditionPlacement(pos, part);
        }
        return null;
    }

    @Nullable
    public ExecutablePlacement externalPlacement(int slot) {
        return this.externalPlacement(this.create(this.size, slot, this.material));
    }

    @Nullable
    public ExecutablePlacement externalPlacement(MicroblockPart part) {
        BlockPos pos = this.pos.m_121945_(Direction.m_122376_((int)this.side));
        if (TileMultipart.canPlacePart((UseOnContext)new MultipartPlaceContext(this.player, this.hand, this.hit).applyOffset(), part)) {
            return new ExecutablePlacement.AdditionPlacement(pos, part);
        }
        return null;
    }

    public static double getHitDepth(Vector3 vHit, int side) {
        return vHit.copy().scalarProject(Rotation.axes[side]) + (double)(side % 2 ^ 1);
    }

    public MicroblockPart create(int size, int slot, MicroMaterial material) {
        MicroblockPart part = this.microFactory.create(this.level.f_46443_, material);
        part.setShape(size, slot);
        return part;
    }
}

