/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.recipe;

import codechicken.lib.util.ItemUtils;
import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.item.SawItem;
import codechicken.microblock.util.MicroMaterialRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class MicroRecipe
extends CustomRecipe {
    private static final int[] splitMap = new int[]{3, 3, -1, 2};

    public MicroRecipe(ResourceLocation id) {
        super(id);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CBMicroblockModContent.MICRO_RECIPE_SERIALIZER.get();
    }

    public ItemStack m_8043_() {
        return ItemMicroBlock.create(1, 1, BlockMicroMaterial.makeMaterialKey(Blocks.f_50069_.m_49966_()));
    }

    public boolean matches(CraftingContainer cont, Level level) {
        return !this.assemble(cont).m_41619_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack assemble(CraftingContainer cont) {
        ItemStack res = MicroRecipe.getHollowResult(cont);
        if (!res.m_41619_()) {
            return res;
        }
        res = MicroRecipe.getGluingResult(cont);
        if (!res.m_41619_()) {
            return res;
        }
        res = MicroRecipe.getThinningResult(cont);
        if (!res.m_41619_()) {
            return res;
        }
        res = MicroRecipe.getSplittingResult(cont);
        if (!res.m_41619_()) {
            return res;
        }
        return MicroRecipe.getHollowFillResult(cont);
    }

    private static ItemStack getHollowResult(CraftingContainer cont) {
        if (!MicroRecipe.getStack(cont, 1, 1).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack first = MicroRecipe.getStack(cont, 0, 0);
        int factory = MicroRecipe.microFactory(first);
        int size = MicroRecipe.microSize(first);
        MicroMaterial material = MicroRecipe.microMaterial(first);
        if (material == null) {
            return ItemStack.f_41583_;
        }
        if (!first.m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get()) || factory != 0) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack item;
            if (i == 4 || (item = cont.m_8020_(i)).m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get()) && MicroRecipe.microMaterial(item) == material && MicroRecipe.microFactory(item) == factory && MicroRecipe.microSize(item) == size) continue;
            return ItemStack.f_41583_;
        }
        return MicroRecipe.create(8, 1, size, material);
    }

    private static ItemStack getGluingResult(CraftingContainer cont) {
        int size = 0;
        int count = 0;
        int smallest = 0;
        int mcrFactory = 0;
        MicroMaterial material = null;
        for (int i = 0; i < 9; ++i) {
            ItemStack item = cont.m_8020_(i);
            if (item.m_41619_()) continue;
            if (!item.m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get())) {
                return ItemStack.f_41583_;
            }
            if (count == 0) {
                size = MicroRecipe.microSize(item);
                mcrFactory = MicroRecipe.microFactory(item);
                material = MicroRecipe.microMaterial(item);
                count = 1;
                smallest = size;
                continue;
            }
            if (MicroRecipe.microFactory(item) != mcrFactory || MicroRecipe.microMaterial(item) != material) {
                return ItemStack.f_41583_;
            }
            if (mcrFactory >= 2 && MicroRecipe.microSize(item) != smallest) {
                return ItemStack.f_41583_;
            }
            smallest = Math.min(smallest, MicroRecipe.microSize(item));
            ++count;
            size += MicroRecipe.microSize(item);
        }
        if (material == null) {
            return ItemStack.f_41583_;
        }
        if (count <= 1) {
            return ItemStack.f_41583_;
        }
        return switch (mcrFactory) {
            case 3 -> {
                if (count == 2) {
                    yield MicroRecipe.create(1, 0, smallest, material);
                }
                yield ItemStack.f_41583_;
            }
            case 2 -> {
                switch (count) {
                    case 2: {
                        yield MicroRecipe.create(1, 3, smallest, material);
                    }
                    case 3: {
                        yield MicroRecipe.create(1, 0, smallest, material);
                    }
                }
                yield ItemStack.f_41583_;
            }
            case 0, 1 -> {
                int base = -1;
                for (int s : new int[]{1, 2, 4}) {
                    if ((s & size) == 0) continue;
                    base = s;
                    break;
                }
                if (base == -1) {
                    yield MicroRecipe.create(size / 8, 0, 8, material);
                }
                if (base <= smallest) {
                    yield ItemStack.f_41583_;
                }
                yield MicroRecipe.create(size / base, mcrFactory, base, material);
            }
            default -> ItemStack.f_41583_;
        };
    }

    private static ItemStack getThinningResult(CraftingContainer cont) {
        SawResult saw = MicroRecipe.getSaw(cont);
        if (saw == null) {
            return ItemStack.f_41583_;
        }
        ItemStack item = MicroRecipe.getStack(cont, saw.col, saw.row + 1);
        if (item.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int size = MicroRecipe.microSize(item);
        MicroMaterial material = MicroRecipe.microMaterial(item);
        int mcrClass = MicroRecipe.microFactory(item);
        if (size == 1 || material == null || !MicroRecipe.canCut(saw.sawTier, material)) {
            return ItemStack.f_41583_;
        }
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                if (c == saw.col && (r == saw.row || r == saw.row + 1) || MicroRecipe.getStack(cont, c, r).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return MicroRecipe.create(2, mcrClass, size / 2, material);
    }

    private static ItemStack getSplittingResult(CraftingContainer cont) {
        SawResult saw = MicroRecipe.getSaw(cont);
        if (saw == null) {
            return ItemStack.f_41583_;
        }
        ItemStack item = MicroRecipe.getStack(cont, saw.col + 1, saw.row);
        if (!item.m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get())) {
            return ItemStack.f_41583_;
        }
        int mcrClass = MicroRecipe.microFactory(item);
        MicroMaterial material = MicroRecipe.microMaterial(item);
        if (material == null || !MicroRecipe.canCut(saw.sawTier, material)) {
            return ItemStack.f_41583_;
        }
        int split = splitMap[mcrClass];
        if (split == -1) {
            return ItemStack.f_41583_;
        }
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                if (r == saw.row && (c == saw.col || c == saw.col + 1) || MicroRecipe.getStack(cont, c, r).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return MicroRecipe.create(2, split, MicroRecipe.microSize(item), material);
    }

    private static ItemStack getHollowFillResult(CraftingContainer cont) {
        ItemStack cover = ItemStack.f_41583_;
        for (int i = 0; i < 9; ++i) {
            ItemStack item = cont.m_8020_(i);
            if (item.m_41619_()) continue;
            if (item.m_41720_() != CBMicroblockModContent.MICRO_BLOCK_ITEM.get() || !cover.m_41619_() || MicroRecipe.microFactory(item) != 1) {
                return ItemStack.f_41583_;
            }
            cover = item;
        }
        if (cover.m_41619_()) {
            return ItemStack.f_41583_;
        }
        MicroMaterial material = MicroRecipe.microMaterial(cover);
        if (material == null) {
            return ItemStack.f_41583_;
        }
        return MicroRecipe.create(1, 0, MicroRecipe.microSize(cover), material);
    }

    @Nullable
    private static SawResult getSaw(CraftingContainer cont) {
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                ItemStack item = MicroRecipe.getStack(cont, r, c);
                Tier tier = SawItem.getSawTier(item.m_41720_());
                if (tier == null) continue;
                return new SawResult(item, tier, r, c);
            }
        }
        return null;
    }

    private static ItemStack create(int amount, int factoryId, int size, MicroMaterial material) {
        if (size == 8) {
            return ItemUtils.copyStack((ItemStack)material.getItem(), (int)amount);
        }
        return ItemMicroBlock.createStack(amount, factoryId, size, material);
    }

    private static boolean canCut(Tier sawTier, MicroMaterial material) {
        Tier required = material.getCutterTier();
        return required != null && SawItem.isTierGTEQ(sawTier, required) || sawTier == CBMicroblockModContent.MAX_SAW_TIER;
    }

    private static ItemStack getStack(CraftingContainer cont, int row, int col) {
        return cont.m_8020_(row + col * cont.m_39347_());
    }

    private static int microFactory(ItemStack stack) {
        if (!stack.m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get())) {
            return 0;
        }
        return ItemMicroBlock.getFactoryID(stack);
    }

    private static int microSize(ItemStack stack) {
        if (!stack.m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get())) {
            return 8;
        }
        return ItemMicroBlock.getSize(stack);
    }

    @Nullable
    public static MicroMaterial microMaterial(ItemStack stack) {
        if (!stack.m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get())) {
            return MicroRecipe.findMaterial(stack);
        }
        return ItemMicroBlock.getMaterialFromStack(stack);
    }

    @Nullable
    public static MicroMaterial findMaterial(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (MicroMaterial material : MicroMaterialRegistry.MICRO_MATERIALS.getValues()) {
            ItemStack mStack = material.getItem();
            if (!mStack.m_150930_(stack.m_41720_()) || !ItemStack.m_41658_((ItemStack)mStack, (ItemStack)stack)) continue;
            return material;
        }
        return null;
    }

    private record SawResult(ItemStack stack, Tier sawTier, int row, int col) {
    }
}

