/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.api.NormalOcclusionTest;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.IconHitEffectsPart;
import codechicken.multipart.api.part.ModelRenderPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class McStatePart
extends BaseMultipart
implements NormalOcclusionPart,
ModelRenderPart,
IconHitEffectsPart {
    public BlockState state;

    public McStatePart() {
        this.state = this.defaultBlockState();
    }

    public McStatePart(BlockState state) {
        this.state = state;
    }

    public abstract BlockState defaultBlockState();

    public abstract ItemStack getDropStack();

    @Override
    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.getDropStack());
    }

    @Override
    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return this.getDropStack();
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)this.state));
    }

    @Override
    public void load(CompoundTag tag) {
        this.state = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("state"));
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeCompoundNBT(NbtUtils.m_129202_((BlockState)this.state));
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.state = NbtUtils.m_129241_((CompoundTag)packet.readCompoundNBT());
    }

    @Override
    public BlockState getCurrentState() {
        return this.state;
    }

    @Nullable
    public MultiPart setStateOnPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState().m_60734_().m_5573_(context);
        if (state != null) {
            this.state = state;
            return this;
        }
        return null;
    }

    @Override
    public float getStrength(Player player, PartRayTraceResult hit) {
        return this.state.m_60625_(player, (BlockGetter)player.f_19853_, new BlockPos(0, -1, 0));
    }

    @Override
    public int getLightEmission() {
        return this.state.m_60791_();
    }

    @Override
    public VoxelShape getShape(CollisionContext context) {
        return this.state.m_60651_((BlockGetter)this.level(), this.pos(), context);
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext context) {
        return this.state.m_60742_((BlockGetter)this.level(), this.pos(), context);
    }

    @Override
    public VoxelShape getRenderOcclusionShape() {
        return this.state.m_60768_((BlockGetter)this.level(), this.pos());
    }

    @Override
    public VoxelShape getInteractionShape() {
        return this.state.m_60820_((BlockGetter)this.level(), this.pos());
    }

    @Override
    public VoxelShape getOcclusionShape() {
        VoxelShape cShape = this.state.m_60812_(null, null);
        return cShape.m_83281_() ? this.state.m_60808_(null, null) : cShape;
    }

    @Override
    public VoxelShape getBlockSupportShape() {
        return this.state.m_60816_((BlockGetter)this.level(), this.pos());
    }

    @Override
    public VoxelShape getVisualShape(CollisionContext context) {
        return this.state.m_60771_((BlockGetter)this.level(), this.pos(), context);
    }

    @Override
    public boolean occlusionTest(MultiPart nPart) {
        return NormalOcclusionTest.test(this, nPart);
    }

    @Override
    public SoundType getPlacementSound(UseOnContext context) {
        return this.state.getSoundType((LevelReader)this.level(), this.pos(), (Entity)context.m_43723_());
    }

    @Override
    public Cuboid6 getBounds() {
        return new Cuboid6(this.getShape(CollisionContext.m_82749_()).m_83215_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult hit) {
        return this.getBrokenIcon(hit.m_82434_().ordinal());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBrokenIcon(int side) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(this.getCurrentState()).getParticleIcon(this.getModelData());
    }
}

