/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.util.ArrayUtils;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.SimpleMultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McStatePart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.SoulTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegisterEvent;

public class ModContent {
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:torch")
    public static MultipartType<TorchPart> torchPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:soul_torch")
    public static MultipartType<SoulTorchPart> soulTorchPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:redstone_torch")
    public static MultipartType<RedstoneTorchPart> redstoneTorchPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:lever")
    public static MultipartType<LeverPart> leverPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:stone_button")
    public static MultipartType<ButtonPart.StoneButtonPart> stoneButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:polished_blackstone_button")
    public static MultipartType<ButtonPart.PolishedBlackstoneButtonPart> polishedBlackstoneButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:oak_button")
    public static MultipartType<ButtonPart.OakButtonPart> oakButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:spruce_button")
    public static MultipartType<ButtonPart.SpruceButtonPart> spruceButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:birch_button")
    public static MultipartType<ButtonPart.BirchButtonPart> birchButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:jungle_button")
    public static MultipartType<ButtonPart.JungleButtonPart> jungleButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:acacia_button")
    public static MultipartType<ButtonPart.AcaciaButtonPart> acaciaButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:dark_oak_button")
    public static MultipartType<ButtonPart.DarkOakButtonPart> darkOakButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:crimson_button")
    public static MultipartType<ButtonPart.CrimsonButtonPart> crimsonButtonPartType;
    @ObjectHolder(registryName="cb_multipart:multipart_types", value="minecraft:warped_button")
    public static MultipartType<ButtonPart.WarpedButtonPart> warpedButtonPartType;

    @SubscribeEvent
    public static void onRegisterMultiParts(RegisterEvent event) {
        event.register(MultiPartRegistries.MULTIPART_TYPES.getRegistryKey(), r -> {
            ModContainer container = ModLoadingContext.get().getActiveContainer();
            ModLoadingContext.get().setActiveContainer(null);
            r.register("torch", new SimpleMultipartType<TorchPart>(e -> new TorchPart()));
            r.register("soul_torch", new SimpleMultipartType<SoulTorchPart>(e -> new SoulTorchPart()));
            r.register("redstone_torch", new SimpleMultipartType<RedstoneTorchPart>(e -> new RedstoneTorchPart()));
            r.register("lever", new SimpleMultipartType<LeverPart>(e -> new LeverPart()));
            r.register("stone_button", new SimpleMultipartType<ButtonPart.StoneButtonPart>(e -> new ButtonPart.StoneButtonPart()));
            r.register("polished_blackstone_button", new SimpleMultipartType<ButtonPart.PolishedBlackstoneButtonPart>(e -> new ButtonPart.PolishedBlackstoneButtonPart()));
            r.register("oak_button", new SimpleMultipartType<ButtonPart.OakButtonPart>(e -> new ButtonPart.OakButtonPart()));
            r.register("spruce_button", new SimpleMultipartType<ButtonPart.SpruceButtonPart>(e -> new ButtonPart.SpruceButtonPart()));
            r.register("birch_button", new SimpleMultipartType<ButtonPart.BirchButtonPart>(e -> new ButtonPart.BirchButtonPart()));
            r.register("jungle_button", new SimpleMultipartType<ButtonPart.JungleButtonPart>(e -> new ButtonPart.JungleButtonPart()));
            r.register("acacia_button", new SimpleMultipartType<ButtonPart.AcaciaButtonPart>(e -> new ButtonPart.AcaciaButtonPart()));
            r.register("dark_oak_button", new SimpleMultipartType<ButtonPart.DarkOakButtonPart>(e -> new ButtonPart.DarkOakButtonPart()));
            r.register("crimson_button", new SimpleMultipartType<ButtonPart.CrimsonButtonPart>(e -> new ButtonPart.CrimsonButtonPart()));
            r.register("warped_button", new SimpleMultipartType<ButtonPart.WarpedButtonPart>(e -> new ButtonPart.WarpedButtonPart()));
            ModLoadingContext.get().setActiveContainer(container);
        });
    }

    @SubscribeEvent
    public static void onRegisterMultiPartConverters(RegisterEvent event) {
        event.register(MultiPartRegistries.PART_CONVERTERS.getRegistryKey(), r -> {
            ModContainer container = ModLoadingContext.get().getActiveContainer();
            ModLoadingContext.get().setActiveContainer(null);
            r.register("torch", new Converter<TorchPart>(TorchPart::new, TorchPart::new, Items.f_42000_, Blocks.f_50081_, Blocks.f_50082_));
            r.register("soul_torch", new Converter<SoulTorchPart>(SoulTorchPart::new, SoulTorchPart::new, Items.f_42053_, Blocks.f_50139_, Blocks.f_50140_));
            r.register("redstone_torch", new Converter<RedstoneTorchPart>(RedstoneTorchPart::new, RedstoneTorchPart::new, Items.f_41978_, Blocks.f_50174_, Blocks.f_50123_));
            r.register("lever", new Converter<LeverPart>(LeverPart::new, LeverPart::new, Items.f_41966_, Blocks.f_50164_));
            r.register("stone_button", new Converter<ButtonPart.StoneButtonPart>(ButtonPart.StoneButtonPart::new, ButtonPart.StoneButtonPart::new, Items.f_42083_, Blocks.f_50124_));
            r.register("polished_blackstone_button", new Converter<ButtonPart.PolishedBlackstoneButtonPart>(ButtonPart.PolishedBlackstoneButtonPart::new, ButtonPart.PolishedBlackstoneButtonPart::new, Items.f_42145_, Blocks.f_50710_));
            r.register("oak_button", new Converter<ButtonPart.OakButtonPart>(ButtonPart.OakButtonPart::new, ButtonPart.OakButtonPart::new, Items.f_42084_, Blocks.f_50251_));
            r.register("spruce_button", new Converter<ButtonPart.SpruceButtonPart>(ButtonPart.SpruceButtonPart::new, ButtonPart.SpruceButtonPart::new, Items.f_42085_, Blocks.f_50252_));
            r.register("birch_button", new Converter<ButtonPart.BirchButtonPart>(ButtonPart.BirchButtonPart::new, ButtonPart.BirchButtonPart::new, Items.f_42086_, Blocks.f_50253_));
            r.register("jungle_button", new Converter<ButtonPart.JungleButtonPart>(ButtonPart.JungleButtonPart::new, ButtonPart.JungleButtonPart::new, Items.f_42087_, Blocks.f_50254_));
            r.register("acacia_button", new Converter<ButtonPart.AcaciaButtonPart>(ButtonPart.AcaciaButtonPart::new, ButtonPart.AcaciaButtonPart::new, Items.f_42088_, Blocks.f_50308_));
            r.register("dark_oak_button", new Converter<ButtonPart.DarkOakButtonPart>(ButtonPart.DarkOakButtonPart::new, ButtonPart.DarkOakButtonPart::new, Items.f_42089_, Blocks.f_50309_));
            r.register("crimson_button", new Converter<ButtonPart.CrimsonButtonPart>(ButtonPart.CrimsonButtonPart::new, ButtonPart.CrimsonButtonPart::new, Items.f_42090_, Blocks.f_50669_));
            r.register("warped_button", new Converter<ButtonPart.WarpedButtonPart>(ButtonPart.WarpedButtonPart::new, ButtonPart.WarpedButtonPart::new, Items.f_42144_, Blocks.f_50670_));
            ModLoadingContext.get().setActiveContainer(container);
        });
    }

    private static class Converter<T extends McStatePart>
    extends PartConverter {
        private final Supplier<T> factory;
        private final Function<BlockState, T> blockFactory;
        private final Item item;
        private final Block[] blocks;

        private Converter(Supplier<T> factory, Function<BlockState, T> blockFactory, Item item, Block ... blocks) {
            this.factory = factory;
            this.blockFactory = blockFactory;
            this.item = item;
            this.blocks = blocks;
        }

        @Override
        public PartConverter.ConversionResult<Collection<MultiPart>> convert(LevelAccessor world, BlockPos pos, BlockState state) {
            if (this.blocks.length == 0) {
                return PartConverter.emptyResultList();
            }
            if (ArrayUtils.contains((Object[])this.blocks, (Object)state.m_60734_())) {
                return PartConverter.ConversionResult.success(Collections.singleton((MultiPart)this.blockFactory.apply(state)));
            }
            return super.convert(world, pos, state);
        }

        @Override
        public PartConverter.ConversionResult<MultiPart> convert(MultipartPlaceContext context) {
            if (context.m_43722_().m_41720_() != this.item) {
                return Converter.emptyResult();
            }
            MultiPart result = ((McStatePart)this.factory.get()).setStateOnPlacement(context);
            if (result != null) {
                return PartConverter.ConversionResult.success(result);
            }
            return super.convert(context);
        }
    }
}

