/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorLogicButton<TYPE extends Enum<TYPE>>
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismGenerators.rl(MekanismUtils.ResourceType.GUI_BUTTON.getPrefix() + "reactor_logic.png");
    @NotNull
    private final IReactorLogic<TYPE> tile;
    private final int typeOffset;
    private final Supplier<@Nullable TYPE> modeSupplier;

    public ReactorLogicButton(IGuiWrapper gui, int x, int y, int index, @NotNull IReactorLogic<TYPE> tile, IntSupplier indexSupplier, Supplier<TYPE[]> modeList, Consumer<TYPE> onPress) {
        this(gui, x, y, index, tile, onPress, () -> {
            int i = indexSupplier.getAsInt() + index;
            Enum[] modes = (Enum[])modeList.get();
            return i >= 0 && i < modes.length ? modes[i] : null;
        });
    }

    private ReactorLogicButton(IGuiWrapper gui, int x, int y, int index, @NotNull IReactorLogic<TYPE> tile, Consumer<TYPE> onPress, Supplier<@Nullable TYPE> modeSupplier) {
        super(gui, x, y, 128, 22, (Component)Component.m_237119_(), () -> {
            Enum mode = (Enum)modeSupplier.get();
            if (mode != null) {
                onPress.accept(mode);
            }
        }, (onHover, matrix, mouseX, mouseY) -> {
            Enum mode = (Enum)modeSupplier.get();
            if (mode != null) {
                gui.displayTooltips(matrix, mouseX, mouseY, new Component[]{((IReactorLogicMode)((Object)mode)).getDescription()});
            }
        });
        this.typeOffset = 22 * index;
        this.modeSupplier = modeSupplier;
        this.tile = tile;
    }

    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            MekanismRenderer.color((EnumColor)((IReactorLogicMode)((Object)mode)).getColor());
            ReactorLogicButton.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)(mode == this.tile.getMode() ? 22.0f : 0.0f), (int)this.f_93618_, (int)this.f_93619_, (int)128, (int)44);
            MekanismRenderer.resetColor();
        }
    }

    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode != null) {
            this.gui().renderItem(matrix, ((IReactorLogicMode)((Object)mode)).getRenderStack(), 20, 35 + this.typeOffset);
            this.drawString(matrix, (Component)TextComponentUtil.build((Object[])new Object[]{EnumColor.WHITE, mode}), 39, 34 + this.typeOffset, this.titleTextColor());
            super.renderForeground(matrix, mouseX, mouseY);
        }
    }
}

