/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.dimension.additional.SkyDimletType;
import mcjty.rftoolsdim.dimension.client.BlackSkyRenderer;
import mcjty.rftoolsdim.dimension.client.SkyboxRenderer;
import mcjty.rftoolsdim.dimension.client.TexturedSkyRenderer;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class RFToolsDimensionSpecialEffects
extends DimensionSpecialEffects {
    private final BlackSkyRenderer blackSky = new BlackSkyRenderer();
    private final TexturedSkyRenderer infernalSky = new TexturedSkyRenderer(new ResourceLocation("rftoolsdim", "textures/sky/redlines.png"));
    private final SkyboxRenderer starsSky = new SkyboxRenderer(new ResourceLocation("rftoolsdim", "textures/sky/stars1.png"), new ResourceLocation("rftoolsdim", "textures/sky/stars1a.png"));
    private final SkyboxRenderer nebulaSky = new SkyboxRenderer(new ResourceLocation("rftoolsdim", "textures/sky/stars3.png"), new ResourceLocation("rftoolsdim", "textures/sky/stars3a.png"));
    private static final Vec3 RED_FOG = new Vec3(1.0, 0.0, 0.0);
    private static final Vec3 BLACK_FOG = new Vec3(0.0, 0.0, 0.0);
    private static final Vec3 WHITE_FOG = new Vec3(1.0, 1.0, 1.0);
    private static long cachedSkyMask = -1L;

    public RFToolsDimensionSpecialEffects() {
        super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public static void clearCache() {
        cachedSkyMask = -1L;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        long skyMask = this.getSkyMask();
        if (SkyDimletType.BLACK.match(skyMask)) {
            return this.blackSky.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        if (SkyDimletType.INFERNAL.match(skyMask)) {
            return this.infernalSky.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        if (SkyDimletType.STARS.match(skyMask)) {
            return this.starsSky.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        if (SkyDimletType.NEBULA.match(skyMask)) {
            return this.nebulaSky.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        return false;
    }

    @Nonnull
    public DimensionSpecialEffects.SkyType m_108883_() {
        long skyMask = this.getSkyMask();
        if (SkyDimletType.END.match(skyMask)) {
            return DimensionSpecialEffects.SkyType.END;
        }
        return DimensionSpecialEffects.SkyType.NORMAL;
    }

    public float m_108871_() {
        long skyMask = this.getSkyMask();
        if (SkyDimletType.NOCLOUDS.match(skyMask)) {
            return Float.NaN;
        }
        return super.m_108871_();
    }

    private long getSkyMask() {
        if (cachedSkyMask == -1L) {
            ClientDimensionData.ClientData clientData = ClientDimensionData.get().getClientData(Minecraft.m_91087_().f_91073_.m_46472_().m_135782_());
            cachedSkyMask = clientData.skyDimletTypes();
        }
        return cachedSkyMask;
    }

    public Vec3 m_5927_(Vec3 vec, float bright) {
        long skyMask = this.getSkyMask();
        if (SkyDimletType.REDFOG.match(skyMask) || SkyDimletType.THICKREDFOG.match(skyMask)) {
            return RED_FOG;
        }
        if (SkyDimletType.BLACKFOG.match(skyMask) || SkyDimletType.THICKBLACKFOG.match(skyMask)) {
            return BLACK_FOG;
        }
        if (SkyDimletType.WHITEFOG.match(skyMask) || SkyDimletType.THICKWHITEFOG.match(skyMask)) {
            return WHITE_FOG;
        }
        return vec.m_82542_((double)(bright * 0.94f + 0.06f), (double)(bright * 0.94f + 0.06f), (double)(bright * 0.91f + 0.09f));
    }

    public boolean m_5781_(int x, int z) {
        long skyMask = this.getSkyMask();
        return SkyDimletType.THICKREDFOG.match(skyMask) || SkyDimletType.THICKBLACKFOG.match(skyMask) || SkyDimletType.THICKWHITEFOG.match(skyMask);
    }
}

