/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.enscriber.blocks;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.data.DimensionCreator;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.items.DimletItem;
import mcjty.rftoolsdim.modules.enscriber.EnscriberModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class EnscriberTileEntity
extends GenericTileEntity {
    public static final int SLOT_DIMLETS = 0;
    public static final int SIZE_DIMLETS = 91;
    public static final int SLOT_TAB = 91;
    private DescriptorError error = DescriptorError.OK;
    private int clientErrorCode = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(92).box(SlotDefinition.specific(DimletItem::isReadyDimlet), 0, 13, 7, 13, 7).slot(SlotDefinition.specific(EnscriberTileEntity::isDimensionTab), 91, 13, 142).playerSlots(85, 142));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid((slot, stack) -> {
        if (slot == 91) {
            return EnscriberTileEntity.isDimensionTab(stack);
        }
        return stack.m_41720_() instanceof DimletItem;
    }).onUpdate((slot, stack) -> this.validateDimlets()).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Enscriber").containerSupplier(DefaultContainerProvider.container(EnscriberModule.CONTAINER_ENSCRIBER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).shortListener(Sync.integer(() -> this.error.getCode().ordinal(), v -> {
        this.clientErrorCode = v;
    })).setupSync((GenericTileEntity)this));
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_STORE = Command.create((String)"enscriber.store", (te, player, params) -> te.storeDimlets(player, (String)params.get(PARAM_NAME)));
    @ServerCommand
    public static final Command<?> CMD_EXTRACT = Command.create((String)"enscriber.extract", (te, player, params) -> te.extractDimlets());

    public EnscriberTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnscriberModule.TYPE_ENSCRIBER.get(), pos, state);
    }

    private static boolean isDimensionTab(ItemStack s) {
        return s.m_41720_() == DimensionBuilderModule.EMPTY_DIMENSION_TAB.get() || s.m_41720_() == DimensionBuilderModule.REALIZED_DIMENSION_TAB.get();
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(EnscriberTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimensions/enscriber")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.ROTATION;
            }
        };
    }

    public String getDimensionName() {
        CompoundTag tagCompound;
        ItemStack stack = this.items.getStackInSlot(91);
        if (!stack.m_41619_() && stack.m_41720_() == DimensionBuilderModule.REALIZED_DIMENSION_TAB.get() && (tagCompound = stack.m_41783_()) != null) {
            return tagCompound.m_128461_("name");
        }
        return null;
    }

    private boolean checkOwnerDimlet() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            DimletKey dimletKey = DimletTools.getDimletKey(stack);
            if (!DimletTools.isOwnerDimlet(dimletKey)) continue;
            return true;
        }
        return false;
    }

    private void storeDimlets(Player player, String name) {
        if (((Boolean)DimensionConfig.OWNER_DIMLET_REQUIRED.get()).booleanValue() && !this.checkOwnerDimlet()) {
            Logging.warn((Player)player, (String)"You need an owner dimlet to make a dimension!");
            return;
        }
        DimensionDescriptor descriptor = this.convertToDimensionDescriptor(player);
        ItemStack realizedTab = this.createRealizedTab(descriptor);
        DimensionData data = PersistantDimensionManager.get(this.f_58857_).getData(descriptor);
        if (data != null) {
            name = data.getId().m_135815_();
            player.m_5661_((Component)ComponentFactory.literal((String)"This dimension already existed! If this is what you wanted then that's fine. Otherwise you need digit dimlets to make new unique dimensions. The dimlet sequence uniquely identifies a dimension. Names can't be changed").m_130940_(ChatFormatting.YELLOW), false);
        } else if (!DimensionCreator.get().isNameAvailable(this.f_58857_, null, name)) {
            player.m_5661_((Component)ComponentFactory.literal((String)"This name is already used by another dimension!").m_130940_(ChatFormatting.YELLOW), false);
            return;
        }
        for (int i = 0; i < 91; ++i) {
            this.items.setStackInSlot(i, ItemStack.f_41583_);
        }
        realizedTab.m_41784_().m_128359_("name", name);
        this.items.setStackInSlot(91, realizedTab);
        this.m_6596_();
    }

    private ItemStack createRealizedTab(DimensionDescriptor descriptor) {
        ItemStack realizedTab = new ItemStack((ItemLike)DimensionBuilderModule.REALIZED_DIMENSION_TAB.get(), 1);
        CompoundTag tagCompound = realizedTab.m_41784_();
        String compact = descriptor.compact();
        tagCompound.m_128359_("descriptor", compact);
        PersistantDimensionManager mgr = PersistantDimensionManager.get(this.f_58857_);
        DimensionData data = mgr.getData(descriptor);
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        if (data != null) {
            tagCompound.m_128405_("ticksLeft", 0);
            tagCompound.m_128359_("dimension", data.getId().toString());
            try {
                compiledDescriptor.compile(descriptor, data.getRandomizedDescriptor());
            }
            catch (DescriptorError descriptorError) {}
        } else {
            try {
                compiledDescriptor.compile(descriptor, DimensionDescriptor.EMPTY);
            }
            catch (DescriptorError descriptorError) {
                // empty catch block
            }
            tagCompound.m_128405_("ticksLeft", compiledDescriptor.getActualTickCost());
        }
        tagCompound.m_128405_("tickCost", compiledDescriptor.getActualTickCost());
        tagCompound.m_128405_("rfCreateCost", compiledDescriptor.getCreateCostPerTick());
        tagCompound.m_128405_("rfMaintainCost", compiledDescriptor.getActualPowerCost());
        return realizedTab;
    }

    private DimensionDescriptor convertToDimensionDescriptor(@Nullable Player player) {
        DimensionDescriptor descriptor = new DimensionDescriptor();
        List<DimletKey> dimlets = descriptor.getDimlets();
        long forcedSeed = 0L;
        for (int i = 0; i < 91; ++i) {
            ItemStack stack = this.items.getStackInSlot(i + 0);
            if (stack.m_41619_()) continue;
            DimletKey key = DimletTools.getDimletKey(stack);
            DimletSettings settings = DimletDictionary.get().getSettings(key);
            if (settings != null) {
                dimlets.add(key);
                CompoundTag tagCompound = stack.m_41783_();
                if (tagCompound == null || tagCompound.m_128454_("forcedSeed") == 0L) continue;
                forcedSeed = tagCompound.m_128454_("forcedSeed");
                continue;
            }
            if (player == null) continue;
            Logging.warn((Player)player, (String)("Dimlet " + key.type().name() + "." + key.key() + " was not included in the tab because it is blacklisted"));
        }
        return descriptor;
    }

    private void validateDimlets() {
        DimensionDescriptor descriptor = this.convertToDimensionDescriptor(null);
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        try {
            compiledDescriptor.compile(descriptor, DimensionDescriptor.EMPTY);
            this.error = DescriptorError.OK;
        }
        catch (DescriptorError e) {
            this.error = e;
        }
    }

    public int getClientErrorCode() {
        return this.clientErrorCode;
    }

    private void extractDimlets() {
        ItemStack realizedTab = this.items.getStackInSlot(91);
        CompoundTag tagCompound = realizedTab.m_41783_();
        if (tagCompound != null) {
            long forcedSeed = tagCompound.m_128454_("forcedSeed");
            String descString = tagCompound.m_128461_("descriptor");
            DimensionDescriptor descriptor = new DimensionDescriptor();
            descriptor.read(descString);
            List<DimletKey> dimlets = descriptor.getDimlets();
            int idx = 0;
            for (DimletKey key : dimlets) {
                boolean hasDimension = tagCompound.m_128441_("dimension");
                if (((Boolean)DimensionConfig.OWNER_DIMLET_REQUIRED.get()).booleanValue() && hasDimension && DimletTools.isOwnerDimlet(key)) continue;
                ItemStack dimletStack = DimletTools.getDimletStack(key);
                this.items.setStackInSlot(idx, dimletStack);
                ++idx;
            }
        }
        this.items.setStackInSlot(91, new ItemStack((ItemLike)DimensionBuilderModule.EMPTY_DIMENSION_TAB.get()));
        this.m_6596_();
    }
}

