/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class BiomeAbsorberTileEntity
extends TickingTileEntity {
    private int absorbing = 0;
    private String biomeId = null;

    public BiomeAbsorberTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EssencesModule.TYPE_BIOME_ABSORBER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60955_()).tileEntitySupplier(BiomeAbsorberTileEntity::new).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/dimlet_workbench")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"block", BiomeAbsorberTileEntity::getBiomeName), TooltipBuilder.parameter((String)"progress", BiomeAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getBiomeName(ItemStack stack) {
        String biome = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128461_, (String)"biome", null);
        if (biome == null) {
            return "<Not Set>";
        }
        ResourceLocation id = new ResourceLocation(biome);
        String trans = "biome." + id.m_135827_() + "." + id.m_135815_();
        return I18n.m_118938_((String)trans, (Object[])new Object[0]);
    }

    public static String getBiome(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128461_, (String)"biome", null);
    }

    private static String getProgressName(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxBiomeAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxBiomeAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
    }

    protected void tickClient() {
        if (this.absorbing > 0) {
            RandomSource rand = this.f_58857_.f_46441_;
            double u = rand.m_188501_() * 2.0f - 1.0f;
            double v = (float)((double)(rand.m_188501_() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)((float)this.m_58899_().m_123341_() + 0.5f) + x * r, (double)((float)this.m_58899_().m_123342_() + 0.5f) + y * r, (double)((float)this.m_58899_().m_123343_() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public String getAbsorbingBiome() {
        return this.biomeId;
    }

    protected void tickServer() {
        Holder biome;
        if (this.biomeId == null) {
            biome = this.m_58904_().m_204166_(this.m_58899_());
            this.biomeId = Tools.getId((CommonLevelAccessor)this.f_58857_, (Biome)((Biome)biome.m_203334_())).toString();
            this.absorbing = (Integer)EssencesConfig.maxBiomeAbsorption.get();
            this.m_6596_();
        }
        if (this.absorbing > 0) {
            biome = this.f_58857_.m_204166_(this.f_58858_);
            if (!Tools.getId((CommonLevelAccessor)this.f_58857_, (Biome)((Biome)biome.m_203334_())).toString().equals(this.biomeId)) {
                return;
            }
            --this.absorbing;
            this.m_6596_();
        }
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("absorbing", this.absorbing);
        if (this.biomeId != null) {
            info.m_128359_("biome", this.biomeId);
        }
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.absorbing = info.m_128451_("absorbing");
        this.biomeId = info.m_128441_("biome") ? info.m_128461_("biome") : null;
    }
}

