/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.mixin.forge;

import earth.terrarium.handcrafted.common.item.RenderedBlockItem;
import earth.terrarium.handcrafted.common.item.RenderedItem;
import earth.terrarium.handcrafted.forge.HandcraftedClientForge;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={RenderedItem.class, RenderedBlockItem.class})
public abstract class RenderedItemMixin
extends Item {
    public RenderedItemMixin(Item.Properties settings) {
        super(settings);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        final RenderedItemMixin item = this;
        consumer.accept(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer = null;
            private boolean hasCheckedSinceInit = false;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (HandcraftedClientForge.hasInitializedRenderers() && !this.hasCheckedSinceInit) {
                    this.renderer = HandcraftedClientForge.getItemRenderer((ItemLike)item);
                    this.hasCheckedSinceInit = true;
                }
                return this.renderer == null ? super.getCustomRenderer() : this.renderer;
            }
        });
    }
}

