/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dan200.computercraft.ComputerCraft;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ModelProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator.PathProvider blockStatePath;
    private final DataGenerator.PathProvider modelPath;
    private final Consumer<BlockModelGenerators> blocks;
    private final Consumer<ItemModelGenerators> items;

    public ModelProvider(DataGenerator generator, Consumer<BlockModelGenerators> blocks, Consumer<ItemModelGenerators> items) {
        this.blockStatePath = generator.m_236036_(DataGenerator.Target.RESOURCE_PACK, "blockstates");
        this.modelPath = generator.m_236036_(DataGenerator.Target.RESOURCE_PACK, "models");
        this.blocks = blocks;
        this.items = items;
    }

    public void m_213708_(@Nonnull CachedOutput output) {
        HashMap blockStates = new HashMap();
        Consumer<BlockStateGenerator> addBlockState = generator -> {
            Block block = generator.m_6968_();
            if (blockStates.containsKey(block)) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
            blockStates.put(block, generator);
        };
        HashMap<ResourceLocation, DelegatedModel> models = new HashMap<ResourceLocation, DelegatedModel>();
        BiConsumer<ResourceLocation, Supplier> addModel = (id, contents) -> {
            if (models.containsKey(id)) {
                throw new IllegalStateException("Duplicate model definition for " + id);
            }
            models.put((ResourceLocation)id, (DelegatedModel)contents);
        };
        HashSet explicitItems = new HashSet();
        this.blocks.accept(new BlockModelGenerators(addBlockState, addModel, explicitItems::add));
        this.items.accept(new ItemModelGenerators(addModel));
        for (Block block : ForgeRegistries.BLOCKS) {
            ResourceLocation model;
            Item item;
            if (!blockStates.containsKey(block) || (item = (Item)Item.f_41373_.get(block)) == null || explicitItems.contains(item) || models.containsKey(model = ModelLocationUtils.m_125571_((Item)item))) continue;
            models.put(model, new DelegatedModel(ModelLocationUtils.m_125576_((Block)block)));
        }
        this.saveCollection(output, blockStates, x -> this.blockStatePath.m_236048_(ForgeRegistries.BLOCKS.getKey(x)));
        this.saveCollection(output, models, arg_0 -> ((DataGenerator.PathProvider)this.modelPath).m_236048_(arg_0));
    }

    private <T> void saveCollection(CachedOutput output, Map<T, ? extends Supplier<JsonElement>> items, Function<T, Path> getLocation) {
        for (Map.Entry<T, Supplier<JsonElement>> entry : items.entrySet()) {
            Path path = getLocation.apply(entry.getKey());
            try {
                DataProvider.m_236072_((CachedOutput)output, (JsonElement)entry.getValue().get(), (Path)path);
            }
            catch (Exception exception) {
                ComputerCraft.log.error("Couldn't save {}", (Object)path, (Object)exception);
            }
        }
    }

    @Nonnull
    public String m_6055_() {
        return "Block State Definitions";
    }
}

