/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.forge.vendored.jsonem.serialization;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.foundationgames.automobility.forge.mixin.jsonem.CubeDefinitionAccess;
import io.github.foundationgames.automobility.forge.mixin.jsonem.CubeDeformationAccess;
import io.github.foundationgames.automobility.forge.mixin.jsonem.LayerDefinitionAccess;
import io.github.foundationgames.automobility.forge.mixin.jsonem.MaterialDefinitionAccess;
import io.github.foundationgames.automobility.forge.mixin.jsonem.PartDefinitionAccess;
import io.github.foundationgames.automobility.forge.vendored.jsonem.serialization.LazyTypeUnboundedMapCodec;
import io.github.foundationgames.automobility.forge.vendored.jsonem.util.UVPairComparable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDefinition;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MaterialDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.model.geom.builders.UVPair;

public class JsonEMCodecs {
    public static final Codec<MaterialDefinition> MATERIAL_DEFINITION = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(obj -> ((MaterialDefinitionAccess)obj).automobility$width()), (App)Codec.INT.fieldOf("height").forGetter(obj -> ((MaterialDefinitionAccess)obj).automobility$height())).apply((Applicative)instance, MaterialDefinition::new));
    public static final Codec<PartPose> PART_POSE = RecordCodecBuilder.create(instance -> instance.group((App)Vector3f.f_176762_.optionalFieldOf("origin", (Object)Vector3f.f_176763_).forGetter(obj -> new Vector3f(obj.f_171405_, obj.f_171406_, obj.f_171407_)), (App)Vector3f.f_176762_.optionalFieldOf("rotation", (Object)Vector3f.f_176763_).forGetter(obj -> new Vector3f(obj.f_171408_, obj.f_171409_, obj.f_171410_))).apply((Applicative)instance, (origin, rot) -> PartPose.m_171423_((float)origin.m_122239_(), (float)origin.m_122260_(), (float)origin.m_122269_(), (float)rot.m_122239_(), (float)rot.m_122260_(), (float)rot.m_122269_())));
    public static final Codec<CubeDeformation> CUBE_DEFORMATION = Vector3f.f_176762_.xmap(vec -> new CubeDeformation(vec.m_122239_(), vec.m_122260_(), vec.m_122269_()), dil -> new Vector3f(((CubeDeformationAccess)dil).automobility$radiusX(), ((CubeDeformationAccess)dil).automobility$radiusY(), ((CubeDeformationAccess)dil).automobility$radiusZ()));
    public static final Codec<UVPair> UV_PAIR = Codec.FLOAT.listOf().comapFlatMap(vec -> Util.m_143795_((List)vec, (int)2).map(arr -> new UVPairComparable(((Float)arr.get(0)).floatValue(), ((Float)arr.get(1)).floatValue())), vec -> ImmutableList.of((Object)Float.valueOf(vec.m_171612_()), (Object)Float.valueOf(vec.m_171613_())));
    private static final UVPair DEFAULT_UV_SCALE = new UVPairComparable(1.0f, 1.0f);
    public static final Codec<CubeDefinition> CUBE_DEFINITION = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name").forGetter(obj -> Optional.ofNullable(((CubeDefinitionAccess)obj).automobility$name())), (App)Vector3f.f_176762_.fieldOf("offset").forGetter(obj -> ((CubeDefinitionAccess)obj).automobility$offset()), (App)Vector3f.f_176762_.fieldOf("dimensions").forGetter(obj -> ((CubeDefinitionAccess)obj).automobility$dimensions()), (App)CUBE_DEFORMATION.optionalFieldOf("dilation", (Object)CubeDeformation.f_171458_).forGetter(obj -> ((CubeDefinitionAccess)obj).automobility$dilation()), (App)Codec.BOOL.optionalFieldOf("mirror", (Object)false).forGetter(obj -> ((CubeDefinitionAccess)obj).automobility$mirror()), (App)UV_PAIR.fieldOf("uv").forGetter(obj -> ((CubeDefinitionAccess)obj).automobility$uv()), (App)UV_PAIR.optionalFieldOf("uv_scale", (Object)DEFAULT_UV_SCALE).forGetter(obj -> UVPairComparable.of(((CubeDefinitionAccess)obj).automobility$uvScale()))).apply((Applicative)instance, JsonEMCodecs::createCuboidData));
    public static final Codec<PartDefinition> PART_DEFINITION = JsonEMCodecs.createPartDefinitionCodec();
    public static final Codec<LayerDefinition> LAYER_DEFINITION = RecordCodecBuilder.create(instance -> instance.group((App)MATERIAL_DEFINITION.fieldOf("texture").forGetter(obj -> ((LayerDefinitionAccess)obj).automobility$texture()), (App)Codec.unboundedMap((Codec)Codec.STRING, PART_DEFINITION).fieldOf("bones").forGetter(obj -> ((PartDefinitionAccess)((LayerDefinitionAccess)obj).automobility$root().m_171576_()).automobility$children())).apply((Applicative)instance, (texture, bones) -> {
        MeshDefinition data = new MeshDefinition();
        ((PartDefinitionAccess)data.m_171576_()).automobility$children().putAll((Map<String, PartDefinition>)bones);
        return LayerDefinitionAccess.automobility$create(data, texture);
    }));

    private static CubeDefinition createCuboidData(Optional<String> name, Vector3f offset, Vector3f dimensions, CubeDeformation dilation, boolean mirror, UVPair uv, UVPair uvSize) {
        return CubeDefinitionAccess.automobility$create(name.orElse(null), uv.m_171612_(), uv.m_171613_(), offset.m_122239_(), offset.m_122260_(), offset.m_122269_(), dimensions.m_122239_(), dimensions.m_122260_(), dimensions.m_122269_(), dilation, mirror, uvSize.m_171612_(), uvSize.m_171613_());
    }

    private static Codec<PartDefinition> createPartDefinitionCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)PART_POSE.optionalFieldOf("transform", (Object)PartPose.f_171404_).forGetter(obj -> ((PartDefinitionAccess)obj).automobility$transform()), (App)Codec.list(CUBE_DEFINITION).fieldOf("cuboids").forGetter(obj -> ((PartDefinitionAccess)obj).automobility$cuboids()), (App)LazyTypeUnboundedMapCodec.of(Codec.STRING, JsonEMCodecs::createPartDefinitionCodec).optionalFieldOf("children", new HashMap()).forGetter(obj -> ((PartDefinitionAccess)obj).automobility$children())).apply((Applicative)instance, (transform, cuboids, children) -> {
            PartDefinition data = PartDefinitionAccess.automobility$create(cuboids, transform);
            ((PartDefinitionAccess)data).automobility$children().putAll((Map<String, PartDefinition>)children);
            return data;
        }));
    }
}

