/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.forge.vendored.jsonem.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.foundationgames.automobility.forge.vendored.jsonem.JsonEM;
import io.github.foundationgames.automobility.forge.vendored.jsonem.serialization.JsonEMCodecs;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.ForgeHooksClient;

public final class JsonEntityModelUtil {
    public static final Gson GSON = new Gson();

    private JsonEntityModelUtil() {
    }

    public static Optional<LayerDefinition> readJson(InputStream data) {
        JsonElement json = (JsonElement)GSON.fromJson(GSON.newJsonReader((Reader)new InputStreamReader(data)), JsonObject.class);
        return JsonEMCodecs.LAYER_DEFINITION.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().map(Pair::getFirst);
    }

    public static void loadModels(ResourceManager manager, Map<ModelLayerLocation, LayerDefinition> models) {
        ImmutableMap.Builder tempMap = new ImmutableMap.Builder();
        ForgeHooksClient.loadLayerDefinitions((ImmutableMap.Builder)tempMap);
        Stream layers = Streams.concat((Stream[])new Stream[]{ModelLayers.m_171288_(), tempMap.build().keySet().stream().filter(ml -> "automobility".equals(ml.m_171123_().m_135827_()))});
        layers.forEach(layer -> {
            ResourceLocation modelLoc = new ResourceLocation(layer.m_171123_().m_135827_(), "models/entity/" + layer.m_171123_().m_135815_() + "/" + layer.m_171124_() + ".json");
            Optional res = manager.m_213713_(modelLoc);
            if (res.isPresent()) {
                try (InputStream in = ((Resource)res.get()).m_215507_();){
                    Optional<LayerDefinition> data = JsonEntityModelUtil.readJson(in);
                    data.ifPresent(model -> models.put((ModelLayerLocation)layer, (LayerDefinition)model));
                }
                catch (IOException e) {
                    JsonEM.LOG.error((Object)e);
                }
            }
        });
    }
}

