/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.foundationgames.automobility.item.AutomobileComponentItem;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import java.util.LinkedHashSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class AutoMechanicTableRecipeSerializer
implements RecipeSerializer<AutoMechanicTableRecipe> {
    public static final AutoMechanicTableRecipeSerializer INSTANCE = new AutoMechanicTableRecipeSerializer();

    public static ItemStack autoComponentStackFromJson(JsonObject obj) throws JsonSyntaxException, IllegalStateException {
        Item item;
        ResourceLocation id = ResourceLocation.m_135820_((String)obj.get("item").getAsString());
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        ItemStack stack = Registry.f_122827_.m_6612_(id).map(i -> new ItemStack((ItemLike)i, count)).orElse(ItemStack.f_41583_);
        if (obj.has("component") && (item = stack.m_41720_()) instanceof AutomobileComponentItem) {
            AutomobileComponentItem item2 = (AutomobileComponentItem)item;
            ResourceLocation component = ResourceLocation.m_135820_((String)obj.get("component").getAsString());
            if (component != null) {
                item2.setComponent(stack, component);
            }
        }
        return stack;
    }

    public AutoMechanicTableRecipe fromJson(ResourceLocation id, JsonObject json) {
        try {
            ResourceLocation category = ResourceLocation.m_135820_((String)json.get("category").getAsString());
            LinkedHashSet<Ingredient> ingredients = new LinkedHashSet<Ingredient>();
            for (JsonElement ele : json.get("ingredients").getAsJsonArray()) {
                ingredients.add(Ingredient.m_43917_((JsonElement)ele));
            }
            ItemStack result = AutoMechanicTableRecipeSerializer.autoComponentStackFromJson(json.get("result").getAsJsonObject());
            int sortNum = 0;
            if (json.has("sortnum")) {
                sortNum = json.get("sortnum").getAsInt();
            }
            return new AutoMechanicTableRecipe(id, category, ingredients, result, sortNum);
        }
        catch (IllegalStateException ex) {
            throw new JsonSyntaxException("Error parsing Auto Mechanic Table recipe - " + ex.getMessage());
        }
    }

    public AutoMechanicTableRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        ResourceLocation category = ResourceLocation.m_135820_((String)buf.m_130277_());
        int size = buf.readByte();
        LinkedHashSet<Ingredient> ingredients = new LinkedHashSet<Ingredient>();
        for (int i = 0; i < size; ++i) {
            ingredients.add(Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        ItemStack result = buf.m_130267_();
        int sortNum = buf.readInt();
        return new AutoMechanicTableRecipe(id, category, ingredients, result, sortNum);
    }

    public void toNetwork(FriendlyByteBuf buf, AutoMechanicTableRecipe recipe) {
        buf.m_130070_(recipe.category.toString());
        buf.writeByte(recipe.ingredients.size());
        recipe.ingredients.forEach(ing -> ing.m_43923_(buf));
        buf.m_130055_(recipe.result);
        buf.writeInt(recipe.sortNum);
    }
}

