/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AutoMechanicTableScreenHandler
extends AbstractContainerMenu {
    private final Level world;
    private final ContainerLevelAccess context;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    public List<AutoMechanicTableRecipe> recipes;
    public final List<Ingredient> missingIngredients = new ArrayList<Ingredient>();
    public final SimpleContainer inputInv;
    public final Slot outputSlot;
    private final int playerInvSlot;

    public AutoMechanicTableScreenHandler(int syncId, Inventory playerInv) {
        this(syncId, playerInv, ContainerLevelAccess.f_39287_);
    }

    public AutoMechanicTableScreenHandler(int syncId, Inventory playerInv, ContainerLevelAccess ctx) {
        super(Automobility.AUTO_MECHANIC_SCREEN.require("Auto mechanic screen not registered!"), syncId);
        this.world = playerInv.f_35978_.m_9236_();
        this.context = ctx;
        this.inputInv = new SimpleContainer(9){

            public void m_6596_() {
                AutoMechanicTableScreenHandler.this.onInputUpdated();
            }
        };
        for (int s = 0; s < 9; ++s) {
            this.m_38897_(new InputSlot((Container)this.inputInv, s, 8 + s * 18, 88));
        }
        this.outputSlot = this.m_38897_(new OutputSlot((Container)new SimpleContainer(1), 0, 26, 38));
        this.playerInvSlot = this.f_38839_.size();
        int playerInvY = 127;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, playerInvY + row * 18));
            }
        }
        for (int s = 0; s < 9; ++s) {
            this.m_38897_(new Slot((Container)playerInv, s, 8 + s * 18, playerInvY + 58));
        }
        this.recipes = new ArrayList<AutoMechanicTableRecipe>(this.world.m_7465_().m_44013_(AutoMechanicTableRecipe.TYPE));
        Collections.sort(this.recipes);
        this.selectedRecipe.m_6422_(-1);
        this.m_38895_(this.selectedRecipe);
    }

    public Optional<AutoMechanicTableRecipe> getSelectedRecipe() {
        int id = this.selectedRecipe.m_6501_();
        return id >= 0 && this.recipes.size() > 0 && id < this.recipes.size() ? Optional.of(this.recipes.get(id)) : Optional.empty();
    }

    public int getSelectedRecipeId() {
        return this.selectedRecipe.m_6501_();
    }

    private void updateMissingIngredients() {
        this.missingIngredients.clear();
        this.getSelectedRecipe().ifPresent(recipe -> recipe.forMissingIngredients((Container)this.inputInv, this.missingIngredients::add));
    }

    private void updateRecipeState() {
        this.updateMissingIngredients();
        this.getSelectedRecipe().ifPresent(recipe -> {
            if (recipe.matches(this.inputInv, this.world)) {
                this.outputSlot.m_5852_(recipe.m_8043_().m_41777_());
            } else {
                this.outputSlot.m_5852_(ItemStack.f_41583_);
            }
        });
    }

    public boolean m_6366_(Player player, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectRecipe(id);
            return true;
        }
        return super.m_6366_(player, id);
    }

    private void onInputUpdated() {
        this.updateRecipeState();
    }

    private void selectRecipe(int id) {
        this.selectedRecipe.m_6422_(id);
        this.updateRecipeState();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.outputSlot.m_5852_(ItemStack.f_41583_);
        this.context.m_39292_((world, pos) -> this.m_150411_(player, (Container)this.inputInv));
    }

    public boolean m_6875_(Player player) {
        return AutoMechanicTableScreenHandler.m_38889_((ContainerLevelAccess)this.context, (Player)player, (Block)AutomobilityBlocks.AUTO_MECHANIC_TABLE.require());
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.outputSlot && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int fromSlotId) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot fromSlot = (Slot)this.f_38839_.get(fromSlotId);
        if (fromSlot.m_6657_()) {
            ItemStack fromStack = fromSlot.m_7993_();
            Item fromItem = fromStack.m_41720_();
            newStack = fromStack.m_41777_();
            if (fromSlotId == this.outputSlot.f_40219_) {
                fromItem.m_7836_(fromStack, player.f_19853_, player);
                if (!this.m_38903_(fromStack, this.playerInvSlot, this.playerInvSlot + 36, true)) {
                    return ItemStack.f_41583_;
                }
                fromSlot.m_40234_(fromStack, newStack);
            } else if (this.f_38839_.stream().anyMatch(s -> s.f_40218_ == this.inputInv && s.f_40219_ == fromSlotId) ? !this.m_38903_(fromStack, this.playerInvSlot, this.playerInvSlot + 36, false) : (this.missingIngredients.stream().anyMatch(ing -> ing.test(fromStack)) ? !this.m_38903_(fromStack, 0, 8, false) : (fromSlotId >= this.playerInvSlot && fromSlotId < this.playerInvSlot + 27 ? !this.m_38903_(fromStack, this.playerInvSlot + 27, this.playerInvSlot + 36, false) : fromSlotId >= this.playerInvSlot + 27 && fromSlotId < this.playerInvSlot + 36 && !this.m_38903_(fromStack, this.playerInvSlot, this.playerInvSlot + 27, false)))) {
                return ItemStack.f_41583_;
            }
            if (fromStack.m_41619_()) {
                fromSlot.m_5852_(ItemStack.f_41583_);
            }
            fromSlot.m_6654_();
            if (fromStack.m_41613_() == newStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            fromSlot.m_142406_(player, fromStack);
            this.m_38946_();
        }
        return newStack;
    }

    public static class InputSlot
    extends Slot {
        public InputSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }
    }

    public class OutputSlot
    extends Slot {
        public OutputSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            AutoMechanicTableScreenHandler.this.getSelectedRecipe().ifPresent(recipe -> {
                recipe.assemble(AutoMechanicTableScreenHandler.this.inputInv);
                stack.m_41720_().m_7836_(stack, player.m_9236_(), player);
                AutoMechanicTableScreenHandler.this.updateRecipeState();
            });
        }
    }
}

