/*
 * Decompiled with CFR 0.152.
 */
package ru.yurannnzzz.moreredcccompat.morered;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import dan200.computercraft.api.ComputerCraftAPI;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComputerChanneledPowerCapability
implements ChanneledPowerSupplier {
    public static final ResourceLocation LOCATION = new ResourceLocation("moreredxcctcompat", "bundled_redstone");
    private final Direction side;

    public ComputerChanneledPowerCapability(Direction side) {
        this.side = side;
    }

    public int getPowerOnChannel(@NotNull Level world, @NotNull BlockPos wirePos, @NotNull BlockState wireState, @Nullable Direction wireFace, int channel) {
        if (wireFace == null) {
            return 0;
        }
        if (this.side == null) {
            return 0;
        }
        BlockPos targetPos = wirePos.m_121945_(this.side.m_122424_());
        int output = ComputerCraftAPI.getBundledRedstoneOutput((Level)world, (BlockPos)targetPos, (Direction)this.side);
        if (output < 0) {
            return 0;
        }
        int expected = 1 << channel;
        return (output & expected) == expected ? 31 : 0;
    }

    public static class Provider
    implements ICapabilityProvider {
        private final Map<Direction, LazyOptional<ChanneledPowerSupplier>> sidedPowerSuppliers = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
            for (Direction side : Direction.values()) {
                map.put(side, LazyOptional.of(() -> new ComputerChanneledPowerCapability(side)));
            }
        });

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == MoreRedAPI.CHANNELED_POWER_CAPABILITY && side != null) {
                return this.sidedPowerSuppliers.get(side).cast();
            }
            return LazyOptional.empty();
        }
    }
}

