/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.tile.MycelialReactorTile;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.worlddata.MycelialDataManager;
import com.hrznstudio.titanium.block.RotatableBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MycelialReactorBlock
extends IndustrialBlock<MycelialReactorTile> {
    public MycelialReactorBlock() {
        super("mycelial_reactor", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_), MycelialReactorTile.class, (CreativeModeTab)ModuleGenerator.TAB_GENERATOR);
    }

    public BlockEntityType.BlockEntitySupplier<MycelialReactorTile> getTileEntityFactory() {
        return MycelialReactorTile::new;
    }

    @Nonnull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity entity = worldIn.m_7702_(pos);
        if (entity instanceof MycelialReactorTile && placer != null) {
            ((MycelialReactorTile)entity).setOwner(placer.m_20148_().toString());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (player.m_6144_() && !worldIn.f_46443_ && tileEntity instanceof MycelialReactorTile) {
            List<String> available = MycelialDataManager.getReactorAvailable(((MycelialReactorTile)tileEntity).getOwner(), worldIn, false);
            if (available.size() != IMycelialGeneratorType.TYPES.size()) {
                player.m_213846_((Component)Component.m_237113_((String)"Generators not running:").m_130940_(ChatFormatting.RED));
            }
            for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
                if (available.contains(type.getName())) continue;
                player.m_213846_((Component)Component.m_237115_((String)("block.industrialforegoing.mycelial_" + type.getName())).m_130940_(ChatFormatting.RED));
            }
        }
        return super.m_6227_(state, worldIn, pos, player, hand, ray);
    }
}

